/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AddOpExpr;
import org.aspectj.compiler.base.ast.AndAndOpExpr;
import org.aspectj.compiler.base.ast.BitwiseOpExpr;
import org.aspectj.compiler.base.ast.ConditionalOpExpr;
import org.aspectj.compiler.base.ast.EqualityTestOpExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericOpExpr;
import org.aspectj.compiler.base.ast.NumericTestOpExpr;
import org.aspectj.compiler.base.ast.OrOrOpExpr;
import org.aspectj.compiler.base.ast.ShiftOpExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public abstract class BinopExpr
extends Expr {
    protected Expr rand1;
    protected String op;
    protected Expr rand2;

    void checkAssignmentOperatorType() {
        this.discoverType();
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        return this.tryToFold();
    }

    private ASTObject tryToFold() {
        if (this.getLiftType().isAnyType()) {
            return this;
        }
        if (this.rand1 instanceof LiteralExpr && this.rand2 instanceof LiteralExpr) {
            try {
                return this.halfFold(this.getLiftType(), (LiteralExpr)this.rand1, (LiteralExpr)this.rand2).setSource(this);
            }
            catch (ArithmeticException e) {
                return this;
            }
        }
        return this;
    }

    protected abstract Type getLiftType();

    protected abstract LiteralExpr halfFold(Type var1, LiteralExpr var2, LiteralExpr var3);

    public static BinopExpr build(SourceLocation source, String op, Expr rand1, Expr rand2) {
        if ((op = op.intern()) == "+") {
            return new AddOpExpr(source, rand1, op, rand2);
        }
        if (op == "&&") {
            return new AndAndOpExpr(source, rand1, op, rand2);
        }
        if (op == "||") {
            return new OrOrOpExpr(source, rand1, op, rand2);
        }
        if (op == "*" || op == "/" || op == "%" || op == "-") {
            return new NumericOpExpr(source, rand1, op, rand2);
        }
        if (op == "&" || op == "|" || op == "^") {
            return new BitwiseOpExpr(source, rand1, op, rand2);
        }
        if (op == "<<" || op == ">>" || op == ">>>") {
            return new ShiftOpExpr(source, rand1, op, rand2);
        }
        if (op == "<" || op == "<=" || op == ">=" || op == ">") {
            return new NumericTestOpExpr(source, rand1, op, rand2);
        }
        if (op == "==" || op == "!=") {
            return new EqualityTestOpExpr(source, rand1, op, rand2);
        }
        throw new RuntimeException("bad op " + op);
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.rand1);
        writer.writeOp(this.op);
        writer.write(this.rand2);
    }

    protected abstract void cgOp(CodeBuilder var1, Type var2);

    protected void cgEffect(CodeBuilder cb) {
        if (this.op == "/" || this instanceof ConditionalOpExpr || this.op == "+") {
            super.cgEffect(cb);
        } else {
            this.getRand1().cgEffect(cb);
            this.getRand2().cgEffect(cb);
        }
    }

    public Expr getRand1() {
        return this.rand1;
    }

    public void setRand1(Expr _rand1) {
        if (_rand1 != null) {
            _rand1.setParent(this);
        }
        this.rand1 = _rand1;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String _op) {
        this.op = _op;
    }

    public Expr getRand2() {
        return this.rand2;
    }

    public void setRand2(Expr _rand2) {
        if (_rand2 != null) {
            _rand2.setParent(this);
        }
        this.rand2 = _rand2;
    }

    public BinopExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location);
        this.setRand1(_rand1);
        this.setOp(_op);
        this.setRand2(_rand2);
    }

    protected BinopExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.rand1;
            }
            case 1: {
                return this.rand2;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "rand1";
            }
            case 1: {
                return "rand2";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setRand1((Expr)child);
                return;
            }
            case 1: {
                this.setRand2((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "BinopExpr(op: " + this.op + ")";
    }
}

