/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class BreakStmt
extends Stmt {
    protected String label;

    public void unparse(CodeWriter writer) throws IOException {
        writer.writeKeyword("break");
        if (this.label != null) {
            writer.requiredSpace();
            writer.write(this.label);
        }
        writer.closeStmt();
    }

    public void walkFlow(FlowCheckerPass w) {
        try {
            w.doBreak(this.getLabel());
        }
        catch (NoSuchElementException e) {
            if (this.getLabel() == null) {
                this.showError("break outside of switch or loop");
            }
            this.showError("undefined label: " + this.getLabel());
        }
        w.setLive(false);
        w.setVars(FlowCheckerPass.getAllVars());
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        w.doBreak(this.getLabel());
        w.setLive(false);
    }

    protected void cgStmt(CodeBuilder cb) {
        cb.doBreak(this.label);
    }

    protected void registerLocation(CodeBuilder cb) {
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    public BreakStmt(SourceLocation location, String _label) {
        super(location);
        this.setLabel(_label);
    }

    protected BreakStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        BreakStmt ret = new BreakStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.label = this.label;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "BreakStmt(label: " + this.label + ")";
    }
}

