/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public final class ByteType
extends IntishType {
    public String getName() {
        return "byte";
    }

    public int getTypeIndex() {
        return 8;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Byte");
    }

    public ByteType(JavaCompiler compiler) {
        super(compiler);
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return new IntLiteralExpr(this.getAST().getSourceLocation(), (Type)this, (byte)rand.getIntValue());
    }

    public String getDescriptor() {
        return "B";
    }

    void emitCastFromInt(CodeBuilder cb) {
        cb.emitI2B();
    }

    void emitCastFromFloat(CodeBuilder cb) {
        cb.emitF2I();
        cb.emitI2B();
    }

    void emitCastFromLong(CodeBuilder cb) {
        cb.emitL2I();
        cb.emitI2B();
    }

    void emitCastFromDouble(CodeBuilder cb) {
        cb.emitD2I();
        cb.emitI2B();
    }

    void emitAload(CodeBuilder cb) {
        cb.emitBALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitBASTORE();
    }
}

