/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AnyCallExpr;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.CastExpr;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.ExprStmt;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.SOLink;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.SuperExpr;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.TypeExpr;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.AccessFixer;
import org.aspectj.compiler.crosscuts.joinpoints.CalleeSideCallJp;

public class CallExpr
extends AnyCallExpr
implements SOLink {
    protected Expr expr;
    protected String id;
    protected Exprs args;
    protected Method method;
    protected boolean isSuper;

    public void walkFlow(FlowCheckerPass w) {
        if (this.getExpr() != null) {
            w.process(this.getExpr());
        }
        w.process(this.getArgs());
        if (this.getMethod().getThrows() != null) {
            TypeDs ts = this.getMethod().getThrows();
            int i = 0;
            int len = ts.size();
            while (i < len) {
                w.setExns(w.getExns().add((NameType)ts.get(i).getType()));
                ++i;
            }
        }
    }

    public ASTObject postMove(MovingWalker walker) {
        return walker.moveLinkExpr(this);
    }

    public ASTObject postScope(ScopeWalker walker) {
        Type lookupType;
        if (this.method != null) {
            return this;
        }
        if (this.expr != null) {
            lookupType = this.expr.getType();
        } else {
            lookupType = walker.getScope().findMethodLookupType(this.id, this);
            if (lookupType == null) {
                this.showError("can't find any method with name: " + this.id);
                return this;
            }
        }
        this.method = lookupType.getMethod(this.id, this, this.args, true);
        if (this.method == null) {
            this.setType(this.getTypeManager().TYPE_NOT_FOUND);
            return this;
        }
        if (this.expr != null && this.expr instanceof SuperExpr && !this.method.isStatic()) {
            this.setIsSuper(true);
        }
        if (this.getExpr() == null) {
            this.setExpr(this.method.isStatic() ? this.getAST().makeTypeExpr(lookupType) : this.getAST().makeQualifiedThis(lookupType));
        }
        return super.postScope(walker);
    }

    public void postInnerInfo(InnerInfoPass w) {
        if (this.expr == null && this.method != null) {
            w.checkStaticAccess(this, this.method);
            this.setExpr(this.getAST().makePrimary((SemanticObject)this.getMethod(), w.currentType()));
        }
    }

    public boolean hasLegalProtectedAccess(Type fromType) {
        if (this.expr == null || this.getIsSuper() || this.expr instanceof SuperExpr) {
            return true;
        }
        return this.expr.getType().isSubtypeOf(fromType);
    }

    public void checkSpec() {
        if (this.method == null) {
            return;
        }
        if (this.expr instanceof TypeExpr && !this.method.isStatic()) {
            this.showError("non-static method " + this.method.toShortString() + " cannot be accessed through a static reference");
        }
        if (this.getIsSuper() && this.method.isAbstract()) {
            this.showError("abstract method " + this.method.toShortString() + " cannot be target of super");
        }
    }

    public boolean isLegalStmt() {
        return true;
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (this.getIsSuper()) {
            MethodDec superMethodDec = this.getMethodDec();
            CalleeSideCallJp targetPoint = (CalleeSideCallJp)this.getWorld().calleeSideCallPoints.get(superMethodDec);
            if (targetPoint == null || !targetPoint.hasPlans()) {
                return this;
            }
            this.setMethod(targetPoint.getPostMethodDec().getMethod());
        }
        this.setExpr(this.method.updateTargetExpr(this.getExpr()));
        return this;
    }

    public ASTObject fixAccessPost(AccessFixer fixer) {
        if (this.getMethod() == null) {
            return this;
        }
        if (this.getMethod().isAccessible(this, true)) {
            return this;
        }
        this.getCompiler().showMessage("  fixing privileged call: " + this.getMethod().toShortString());
        Method newMethod = this.getMethod().getBackdoorMethod();
        if (!fixer.apply) {
            return this;
        }
        CallExpr newCallExpr = this.getAST().makeCall(newMethod, this.getExpr(), this.getArgs());
        newCallExpr.setSource(this);
        return newCallExpr;
    }

    public MethodDec getMethodDec() {
        return (MethodDec)this.method.getCorrespondingDec();
    }

    public void setMethodDec(MethodDec md) {
        this.setMethod((Method)md.getCorrespondingSemanticObject());
    }

    public CodeDec getCodeDec() {
        return this.getMethodDec();
    }

    public SemanticObject getTarget() {
        return this.getMethod();
    }

    public void setTarget(SemanticObject newTarget) {
        this.setMethod((Method)newTarget);
    }

    public Type getReturnType() {
        return this.getMethod().getReturnType();
    }

    public Type getCalledType() {
        if (this.expr == null) {
            return this.getDeclaringType();
        }
        return this.expr.getType();
    }

    public CallExpr(SourceLocation source, Expr expr, String id) {
        this(source, expr, id, new Exprs(source));
    }

    public Type discoverType() {
        if (this.getMethod() == null) {
            return this.getTypeManager().anyType;
        }
        return this.getMethod().getReturnType();
    }

    static Expr makeParentExpr(Method md, Expr instance) {
        if (instance != null) {
            return instance;
        }
        if (md.isStatic()) {
            return md.getAST().makeTypeExpr(md.getDeclaringType());
        }
        return null;
    }

    public Expr getExprOrThis() {
        if (this.method.isStatic()) {
            return null;
        }
        if (this.expr != null) {
            return this.expr;
        }
        return new ThisExpr(this.getSourceLocation(), this.method.getDeclaringType());
    }

    private boolean isInlinableTarget(Expr e, Type bytecodeType) {
        ThisExpr thisExpr;
        if (e == null) {
            return true;
        }
        if (e instanceof TypeExpr) {
            return true;
        }
        return e instanceof ThisExpr && (thisExpr = (ThisExpr)e).getType() == bytecodeType;
    }

    public boolean tryToInline(Type bytecodeType) {
        MethodDec md;
        block7: {
            if (!this.isInlinableTarget(this.getExpr(), bytecodeType)) {
                return false;
            }
            md = this.getMethodDec();
            if (md.containsTypes()) {
                return false;
            }
            AST ast = this.getAST();
            try {
                if (this.getParent() instanceof ReturnStmt) {
                    RemapWalker rw = new RemapWalker(this.getCompiler(), this.args, md, null, null);
                    this.getParent().replaceWith(rw.remap());
                    break block7;
                }
                if (this.getParent() instanceof ExprStmt) {
                    String label = this.getWorld().genLabel();
                    RemapWalker rw = new RemapWalker(this.getCompiler(), this.args, md, label, null);
                    this.getParent().replaceWith(rw.remap());
                    break block7;
                }
                if (this.isEffectiveCast(this.getParent())) {
                    ReturnStmt s = this.getEnclosingReturnStmt(this);
                    RemapWalker rw = new RemapWalker(this.getCompiler(), this.args, md, null, s.getExpr().getType());
                    s.replaceWith(rw.remap());
                    break block7;
                }
                return false;
            }
            catch (InvalidOptimizationException e) {
                return false;
            }
        }
        md.getDeclaringType().getTypeDec().getBody().remove(md);
        return true;
    }

    private ReturnStmt getEnclosingReturnStmt(ASTObject o) {
        if (o instanceof ReturnStmt) {
            return (ReturnStmt)o;
        }
        return this.getEnclosingReturnStmt(o.getParent());
    }

    private boolean isEffectiveCast(ASTObject o) {
        if (o instanceof ParenExpr) {
            return this.isEffectiveCast(o.getParent());
        }
        if (o instanceof CastExpr) {
            return this.isEffectiveCast1(o.getParent());
        }
        return false;
    }

    private boolean isEffectiveCast1(ASTObject o) {
        if (o instanceof ParenExpr) {
            return this.isEffectiveCast1(o.getParent());
        }
        return o instanceof ReturnStmt;
    }

    public void unparse(CodeWriter writer) {
        if (this.expr != null) {
            writer.write(this.expr);
            writer.write('.');
        }
        if (this.method != null) {
            this.id = this.method.getBytecodeId();
        }
        writer.write(this.id);
        writer.openParen('(');
        writer.write(this.args);
        writer.closeParen(')');
    }

    public CallExpr(SourceLocation source, Method toMethod, Expr instance, Exprs args) {
        this(source, CallExpr.makeParentExpr(toMethod, instance), toMethod.getId(), args, toMethod, false);
    }

    public CallExpr(SourceLocation source, String _id, Exprs _args) {
        this(source, new ThisExpr(source), _id, _args);
    }

    public CallExpr(SourceLocation source, Expr expr, String _id, Exprs _args) {
        this(source, expr, _id, _args, null, false);
    }

    private boolean needsAccessMethod(InnerAccessFixer w) {
        Expr q = this.getExpr();
        MethodDec oldMethodDec = this.getMethodDec();
        if (!w.isAccessible(oldMethodDec, q)) {
            return true;
        }
        if (this.getIsSuper()) {
            return !(this.getExpr() instanceof ThisExpr) && !(this.getExpr() instanceof SuperExpr);
        }
        return false;
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        if (!this.needsAccessMethod(w)) {
            return this;
        }
        Expr q = this.getExpr();
        MethodDec oldMethodDec = this.getMethodDec();
        Type qType = q.getType();
        MethodDec newMethodDec = w.getAccessMethod(qType, oldMethodDec, "", this);
        this.setMethod(newMethodDec.getMethod());
        if (!oldMethodDec.isStatic()) {
            this.getArgs().add(0, q);
            this.setExpr(this.getAST().makeTypeExpr(qType));
        }
        return this;
    }

    public MethodDec buildAccessMethod(InnerAccessFixer w) {
        AST ast = this.getAST();
        Expr q = this.getExpr();
        Type qType = q.getType();
        Type returnType = this.getReturnType();
        Method oldMethod = this.getMethod();
        Formals newFormals = (Formals)oldMethod.getFormals().copy();
        Exprs newArgs = ast.makeVars(newFormals);
        Expr newExpr = w.makeInsidePrimary(oldMethod.isStatic(), newFormals, qType);
        CallExpr newCall = ast.makeCall(oldMethod, newExpr, newArgs);
        if (this.getIsSuper()) {
            newCall.setIsSuper(true);
        }
        return w.makeAccessMethod(returnType, newFormals, newCall);
    }

    protected void cgValue(CodeBuilder cb) {
        NameType ty;
        cb.enterLocation(this.getSourceLocation());
        MethodDec dec = this.getMethodDec();
        String name = dec.getInternalId();
        String descriptor = dec.getDescriptor();
        int delta = dec.getStackDelta();
        if (dec.isStatic()) {
            this.getExpr().cgEffect(cb);
        } else {
            this.getExpr().cgValue(cb);
        }
        this.getArgs().cgValues(cb, dec.getFormals());
        RefType refTy = (RefType)this.getExpr().getType();
        NameType nameType = ty = refTy instanceof ArrayType ? this.getTypeManager().getObjectType() : (NameType)refTy;
        if (dec.getDeclaringType().isObject()) {
            ty = this.getTypeManager().getObjectType();
        }
        if (dec.isStatic()) {
            cb.emitINVOKESTATIC(ty, name, descriptor, delta);
        } else if (this.getIsSuper()) {
            cb.emitINVOKESPECIAL(ty, name, descriptor, delta);
        } else if (dec.isPrivate()) {
            cb.emitINVOKESPECIAL(ty, name, descriptor, delta);
        } else if (ty.isInterface()) {
            int arglen = -delta + dec.getResultType().getSlotCount();
            cb.emitINVOKEINTERFACE(ty, name, descriptor, delta, arglen);
        } else {
            cb.emitINVOKEVIRTUAL(ty, name, descriptor, delta);
        }
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public Exprs getArgs() {
        return this.args;
    }

    public void setArgs(Exprs _args) {
        if (_args != null) {
            _args.setParent(this);
        }
        this.args = _args;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method _method) {
        this.method = _method;
    }

    public boolean getIsSuper() {
        return this.isSuper;
    }

    public void setIsSuper(boolean _isSuper) {
        this.isSuper = _isSuper;
    }

    public CallExpr(SourceLocation location, Expr _expr, String _id, Exprs _args, Method _method, boolean _isSuper) {
        super(location);
        this.setExpr(_expr);
        this.setId(_id);
        this.setArgs(_args);
        this.setMethod(_method);
        this.setIsSuper(_isSuper);
    }

    protected CallExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        CallExpr ret = new CallExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        ret.id = this.id;
        if (this.args != null) {
            ret.setArgs((Exprs)walker.process(this.args));
        }
        ret.method = this.method;
        ret.isSuper = this.isSuper;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
            case 1: {
                return this.args;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "args";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
            case 1: {
                this.setArgs((Exprs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "CallExpr(id: " + this.id + ", " + "method: " + this.method + ", " + "isSuper: " + this.isSuper + ")";
    }

    class RemapWalker
    extends MovingWalker {
        private Exprs args;
        private MethodDec calledMethodDec;
        private String breakLabel;
        private Type desiredReturnType;
        private List argRefs;
        private VarDec returnVarDec;

        public RemapWalker(JavaCompiler compiler, Exprs args, MethodDec calledMethodDec, String breakLabel, Type desiredReturnType) {
            super(compiler);
            this.args = args;
            this.calledMethodDec = calledMethodDec;
            this.breakLabel = breakLabel;
            this.desiredReturnType = desiredReturnType;
        }

        public Stmt remap() {
            AST ast = this.getAST();
            Stmts stmts = this.remapStmts();
            Stmt ret = ast.makeBlock(stmts);
            if (this.breakLabel != null) {
                ret = ast.makeLabeled(this.breakLabel, ret);
            }
            return ret;
        }

        public Stmts remapStmts() {
            AST ast = this.getAST();
            Stmts block = ast.makeStmts();
            this.argRefs = new ArrayList();
            Set effectivelyFinalFormals = this.calledMethodDec.getEffectivelyFinalFormals();
            int i = 0;
            while (i < this.args.size()) {
                FormalDec formal = this.calledMethodDec.getFormals().get(i);
                Type type = formal.getType();
                Expr arg = (Expr)this.args.get(i).copy();
                if (effectivelyFinalFormals.contains(formal) && this.args.get(i).canBeCopied()) {
                    this.argRefs.add(ast.makeCast(type, arg));
                } else {
                    VarDec dec = ast.makeVarDec(type, formal.getId(), arg);
                    block.add(dec);
                    this.argRefs.add(ast.makeVar(dec));
                }
                ++i;
            }
            Stmts body = (Stmts)this.calledMethodDec.getBody().getStmts().copy();
            body = (Stmts)this.process(body);
            block.addAll(body);
            return block;
        }

        protected Expr handleFreeVar(VarExpr var) {
            VarDec varDec = var.getVarDec();
            if (!(varDec instanceof FormalDec)) {
                return super.handleFreeVar(var);
            }
            FormalDec formalDec = (FormalDec)varDec;
            int index = this.calledMethodDec.getFormals().indexOf(formalDec);
            if (index == -1) {
                return super.handleFreeVar(var);
            }
            return (Expr)((Expr)this.argRefs.get(index)).copy();
        }

        private ASTObject handleReturn(ReturnStmt object) {
            AST ast = this.getAST();
            if (this.breakLabel == null) {
                if (this.desiredReturnType != null) {
                    if (this.desiredReturnType.isAssignableFrom(object.getExpr().getType())) {
                        object.setExpr(ast.makeCast(this.desiredReturnType, object.getExpr()));
                    } else {
                        throw new InvalidOptimizationException();
                    }
                }
                return object;
            }
            Stmt stmt = ast.makeBreak(this.breakLabel);
            Expr expr = object.getExpr();
            if (expr == null) {
                return stmt;
            }
            if (expr.canBeCopied()) {
                return stmt;
            }
            if (expr.isLegalStmt()) {
                return ast.makeBlock(ast.makeStmt(expr), stmt);
            }
            return ast.makeVarDec(this.calledMethodDec.getResultType(), "retValue", expr, true);
        }

        public Expr moveThisExpr(ThisExpr thisExpr, Type thisType) {
            return thisExpr;
        }

        public ASTObject process(ASTObject object) {
            if (object instanceof TypeDec || object instanceof CodeDec) {
                return object;
            }
            if ((object = super.process(object)) instanceof ReturnStmt) {
                return this.handleReturn((ReturnStmt)object);
            }
            return object;
        }
    }

    static class InvalidOptimizationException
    extends RuntimeException {
        InvalidOptimizationException() {
        }
    }
}

