/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class CastExpr
extends Expr {
    protected TypeD typeD;
    protected Expr expr;

    public boolean canBeCopied() {
        return this.expr.isUltimatelyLiteral();
    }

    public boolean isUltimatelyLiteral() {
        return this.expr.isUltimatelyLiteral();
    }

    public boolean isPossibleCast() {
        if (this.expr.getType() == null || this.typeD.getType() == null) {
            return true;
        }
        return this.expr.getType().isCoercableTo(this.typeD.getType());
    }

    public void checkSpec() {
        Type exprType = this.expr.getType();
        Type castType = this.typeD.getType();
        this.setType(castType);
        if (!this.isPossibleCast()) {
            this.showError("Can't convert from " + exprType.getString() + " to " + castType.getString());
        }
    }

    public Type discoverType() {
        return this.typeD.getType();
    }

    public void unparse(CodeWriter writer) {
        writer.write('(');
        writer.write(this.typeD);
        writer.write(')');
        if (this.isSynthetic() && !this.isPossibleCast()) {
            writer.write("null");
            return;
        }
        if (this.isSynthetic() && !(this.expr instanceof ParenExpr)) {
            writer.write('(');
            writer.write(this.expr);
            writer.write(')');
        } else {
            writer.write(this.expr);
        }
    }

    protected void cgValue(CodeBuilder cb) {
        this.expr.cgValue(cb);
        this.expr.getType().emitCast(cb, this.typeD.getType());
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        this.checkSpec();
        if (this.expr instanceof LiteralExpr && !this.getTypeD().getType().isObject()) {
            return this.getTypeD().getType().foldCast((LiteralExpr)this.expr);
        }
        return this;
    }

    public TypeD getTypeD() {
        return this.typeD;
    }

    public void setTypeD(TypeD _typeD) {
        if (_typeD != null) {
            _typeD.setParent(this);
        }
        this.typeD = _typeD;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public CastExpr(SourceLocation location, TypeD _typeD, Expr _expr) {
        super(location);
        this.setTypeD(_typeD);
        this.setExpr(_expr);
    }

    protected CastExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        CastExpr ret = new CastExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeD;
            }
            case 1: {
                return this.expr;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeD";
            }
            case 1: {
                return "expr";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeD((TypeD)child);
                return;
            }
            case 1: {
                this.setExpr((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "CastExpr()";
    }
}

