/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public final class CharType
extends IntishType {
    public String getName() {
        return "char";
    }

    public int getTypeIndex() {
        return 5;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Character");
    }

    public CharType(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDescriptor() {
        return "C";
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return new IntLiteralExpr(rand.getSourceLocation(), (Type)this, (char)rand.getIntValue());
    }

    void emitCastFromInt(CodeBuilder cb) {
        cb.emitI2C();
    }

    void emitCastFromFloat(CodeBuilder cb) {
        cb.emitF2I();
        cb.emitI2C();
    }

    void emitCastFromLong(CodeBuilder cb) {
        cb.emitL2I();
        cb.emitI2C();
    }

    void emitCastFromDouble(CodeBuilder cb) {
        cb.emitD2I();
        cb.emitI2C();
    }

    void emitAload(CodeBuilder cb) {
        cb.emitCALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitCASTORE();
    }
}

