/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.ExceptionFinder;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BangExpr;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.PossibleSoftThrowable;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.MethodBuilder;

public abstract class CodeDec
extends Dec
implements PossibleSoftThrowable {
    private boolean _isSoft = false;
    boolean computingMinimalThrows = false;
    private int frameSize;
    protected Modifiers modifiers;
    protected Formals formals;
    protected TypeDs _throws;
    protected CodeBody body;

    public boolean isSoftThrowable() {
        return this._isSoft;
    }

    public void setSoftThrowable() {
        this._isSoft = true;
    }

    public void walkFlow(FlowCheckerPass w) {
        if (this.getBody() != null) {
            this.setupFlowWalker(w);
            w.setLive(true);
            w.process(this.getBody());
            if (!this.getResultType().isVoid() && w.isLive()) {
                this.showError("missing return statement");
            }
        }
    }

    protected void setupFlowWalker(FlowCheckerPass w) {
    }

    public final void walkCleanup(ByteCodeCleanupPass w) {
        w.setLive(true);
        super.walkCleanup(w);
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getBody() != null && this.getResultType().isVoid() && w.isLive()) {
            ReturnStmt s = (ReturnStmt)this.getAST().makeReturn(null).setSource(this.getBody());
            s.setCompletesNormally(false);
            this.getBody().getStmts().add(s);
            this.getBody().setCompletesNormally(false);
        }
        return this;
    }

    public void walkInnerInfo(InnerInfoPass w) {
        int context = w.inMember(this.isStatic());
        super.walkInnerInfo(w);
        w.restoreContext(context);
    }

    public static CodeBody blockToBody(BlockStmt block) {
        if (block == null) {
            return null;
        }
        block.getStmts().clearParent();
        CodeBody body = new CodeBody(block.getSourceLocation(), block.getStmts(), true);
        body.setSource(block);
        return body;
    }

    public void setBody(BlockStmt block) {
        this.setBody(CodeDec.blockToBody(block));
    }

    public abstract String getId();

    public abstract TypeD getResultTypeD();

    public Type getResultType() {
        return this.getResultTypeD().getType();
    }

    public boolean canThrow(Type t) {
        if (t.isUncheckedThrowable()) {
            return true;
        }
        if (this._throws == null) {
            return false;
        }
        int i = 0;
        while (i < this._throws.size()) {
            if (t.isSubtypeOf(this._throws.get(i).getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addThrowsType(Type t) {
        if (this.canThrow(t)) {
            return;
        }
        if (this._throws == null) {
            this._throws = this.getAST().makeTypeDs();
        }
        this._throws.add(t.makeTypeD());
    }

    public void addThrows(Collection throwTypes) {
        Iterator i = throwTypes.iterator();
        while (i.hasNext()) {
            this.addThrowsType((Type)i.next());
        }
    }

    public Set getPossibleCheckedExceptions() {
        if (this._throws == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Type> ret = new HashSet<Type>();
        int i = 0;
        while (i < this._throws.size()) {
            ret.add(this._throws.get(i).getType());
            ++i;
        }
        return Type.filterTopTypes(ret);
    }

    public void checkSpec() {
        if (this._throws == null) {
            return;
        }
        NameType throwableType = this.getTypeManager().getThrowableType();
        int i = 0;
        while (i < this._throws.size()) {
            TypeD throwsTypeD = this._throws.get(i);
            if (!throwsTypeD.getType().isSubtypeOf(throwableType)) {
                throwsTypeD.showTypeError(throwsTypeD.getType(), throwableType);
            }
            ++i;
        }
    }

    public boolean appearsStaticToCaller() {
        return this.isStatic();
    }

    public boolean hasThis() {
        return !this.isStatic();
    }

    public boolean isAlmostApplicable(Exprs params) {
        return params.size() == this.getFormals().size();
    }

    public boolean isApplicable(Exprs parameters) {
        return this.getFormals().canBeCalledWith(parameters);
    }

    public boolean conflictsWith(Dec otherDec) {
        if (!this.getId().equals(otherDec.getId())) {
            return false;
        }
        if (!this.isAccessible(otherDec) && !otherDec.isAccessible(this)) {
            return false;
        }
        if (!(otherDec instanceof CodeDec)) {
            return false;
        }
        CodeDec otherCodeDec = (CodeDec)otherDec;
        return this.getFormals().matches(otherCodeDec.getFormals());
    }

    public boolean isMoreSpecificThan(Dec otherDec) {
        if (!(otherDec instanceof CodeDec)) {
            return false;
        }
        CodeDec other = (CodeDec)otherDec;
        if (!super.isMoreSpecificThan(other)) {
            return false;
        }
        Formals formals1 = this.getFormals();
        Formals formals2 = other.getFormals();
        if (formals1.size() != formals2.size()) {
            return false;
        }
        int i = 0;
        while (i < formals1.size()) {
            if (!formals1.get(i).getType().isMethodConvertableTo(formals2.get(i).getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Set getEffectivelyFinalFormals() {
        FinalFinderWalker ffw = new FinalFinderWalker(this.getCompiler(), this.getFormals().makeSet());
        ffw.process(this.getBody());
        return ffw.curr;
    }

    public void preScope(ScopeWalker walker) {
        walker.pushScope(this.makeBlockScope(walker));
    }

    public ASTObject postScope(ScopeWalker walker) {
        walker.popScope();
        return this;
    }

    public void computeMinimalThrows() {
        if (this.computingMinimalThrows || this.getBody() == null) {
            return;
        }
        this.computingMinimalThrows = true;
        Set exceptions = ExceptionFinder.getPossibleExceptions(this.getBody(), false);
        this.computingMinimalThrows = false;
        int N = exceptions.size();
        if (N == 0) {
            this.setThrows(null);
            return;
        }
        exceptions = Type.filterTopTypes(exceptions);
        TypeDs newThrows = this.getAST().makeTypeDs();
        Iterator iter = exceptions.iterator();
        while (iter.hasNext()) {
            Type type = (Type)iter.next();
            newThrows.add(type.makeTypeD());
        }
        this.setThrows(newThrows);
    }

    public Set getCallExprs() {
        return null;
    }

    public void cleanup() {
        if (this.body != null) {
            this.body.cleanup();
        }
        super.cleanup();
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(int frameSize) {
        this.frameSize = frameSize;
    }

    public void walkFrameLoc(FrameLocPass walker) {
        walker.setfs(!this.isStatic() || this instanceof ConstructorDec ? 1 : 0);
        super.walkFrameLoc(walker);
        this.setFrameSize(walker.getmaxfs());
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        walker.enterCodeDec(this);
        walker.inCode(this.isStatic());
        this.walk(walker);
        walker.leaveCodeDec();
    }

    protected void cgMember(ClassfileBuilder cfb) {
        TypeDs exns;
        if (this.getOptions().bcgverbose) {
            System.err.println("generating for " + this);
        }
        MethodBuilder mb = cfb.getMethodBuilder();
        mb.addAccessFlags(this.getModifiers().getValue());
        mb.setName(this.getInternalId());
        mb.setDescriptor(this.getDescriptor());
        if (this.isDeprecated()) {
            mb.setDeprecated();
        }
        if ((exns = this.getThrows()) != null) {
            Iterator i = exns.iterator();
            while (i.hasNext()) {
                TypeD typeD = (TypeD)i.next();
                mb.addToExceptionsAttribute((NameType)typeD.getType());
            }
        }
        if (this.getBody() != null) {
            CodeBuilder cb = mb.getCodeBuilder();
            this.cgCodeMember(cb);
            mb.setCode(cb);
        }
        cfb.addMethod(mb);
    }

    protected void cgCodeMember(CodeBuilder cb) {
        throw new RuntimeException("unsupported " + this);
    }

    public String getDescriptor() {
        throw new RuntimeException("unsupported " + this);
    }

    public int getStackDelta() {
        throw new RuntimeException("unsupported " + this);
    }

    String getInternalId() {
        return this.getBytecodeId();
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Modifiers _modifiers) {
        if (_modifiers != null) {
            _modifiers.setParent(this);
        }
        this.modifiers = _modifiers;
    }

    public Formals getFormals() {
        return this.formals;
    }

    public void setFormals(Formals _formals) {
        if (_formals != null) {
            _formals.setParent(this);
        }
        this.formals = _formals;
    }

    public TypeDs getThrows() {
        return this._throws;
    }

    public void setThrows(TypeDs __throws) {
        if (__throws != null) {
            __throws.setParent(this);
        }
        this._throws = __throws;
    }

    public CodeBody getBody() {
        return this.body;
    }

    public void setBody(CodeBody _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public CodeDec(SourceLocation location, Modifiers _modifiers, Formals _formals, TypeDs __throws, CodeBody _body) {
        super(location);
        this.setModifiers(_modifiers);
        this.setFormals(_formals);
        this.setThrows(__throws);
        this.setBody(_body);
    }

    protected CodeDec(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.formals;
            }
            case 2: {
                return this._throws;
            }
            case 3: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "formals";
            }
            case 2: {
                return "throws";
            }
            case 3: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setFormals((Formals)child);
                return;
            }
            case 2: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 3: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 4;
    }

    public String getDefaultDisplayName() {
        return "CodeDec()";
    }

    private class FinalFinderWalker
    extends Walker {
        Set curr;

        FinalFinderWalker(JavaCompiler c, Set curr) {
            super(c);
            this.curr = curr;
        }

        public void postProcess(ASTObject o) {
            BangExpr be;
            AssignableExpr lhs;
            if (o instanceof BangExpr && (lhs = (be = (BangExpr)o).getLhs()) instanceof VarExpr) {
                VarDec vd = ((VarExpr)lhs).getVarDec();
                this.curr.remove(vd);
            }
        }
    }
}

