/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class Decs
extends Stmt {
    protected int size;
    public Dec[] children;

    public List getList() {
        return Arrays.asList(this.children);
    }

    public ListIterator iterator() {
        return new ListIterator(){
            private int i = -1;
            private boolean isRemovable = false;

            public int previousIndex() {
                return this.i == -1 ? Decs.this.size - 1 : this.i - 1;
            }

            public boolean hasPrevious() {
                int i = this.previousIndex();
                return i >= 0 && i < Decs.this.size;
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.isRemovable = true;
                return Decs.this.children[--this.i];
            }

            public int nextIndex() {
                return this.i == -1 ? 0 : this.i + 1;
            }

            public boolean hasNext() {
                int i = this.nextIndex();
                return i >= 0 && i < Decs.this.size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isRemovable = true;
                return Decs.this.children[++this.i];
            }

            public void remove() {
                if (!this.isRemovable) {
                    throw new IllegalStateException();
                }
                this.isRemovable = false;
                Decs.this.remove(this.i--);
            }

            public void set(Object o) {
                if (!this.isRemovable) {
                    throw new IllegalStateException();
                }
                Decs.this.set(this.i, (Dec)o);
            }

            public void add(Object o) {
                if (this.i == -1) {
                    this.i = 0;
                }
                this.isRemovable = false;
                Decs.this.add(this.i++, (Dec)o);
            }
        };
    }

    public void append(Decs decs) {
        int i = 0;
        while (i < decs.size()) {
            this.append(decs.get(i));
            ++i;
        }
    }

    public void append(Dec dec) {
        this.add(dec);
    }

    public void prepend(Dec dec) {
        this.add(0, dec);
    }

    public void unparse(CodeWriter writer) {
        int N = this.size;
        int i = 0;
        while (i < N) {
            if (i > 0) {
                writer.newLine();
            }
            writer.write(this.children[i]);
            ++i;
        }
    }

    public void remove(Dec dec) {
        int i = this.indexOf(dec);
        if (i != -1) {
            this.remove(i);
        }
    }

    public void cleanup() {
        int i = 0;
        while (i < this.size) {
            this.children[i].cleanup();
            ++i;
        }
        super.cleanup();
    }

    protected void cgStmt(CodeBuilder cb) {
        int i = 0;
        int len = this.size;
        while (i < len) {
            this.children[i].cgTop(cb);
            ++i;
        }
    }

    public Decs(SourceLocation location, Dec[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public Decs(SourceLocation location) {
        this(location, new Dec[0]);
    }

    public Decs(SourceLocation location, Dec child1) {
        this(location, new Dec[]{child1});
    }

    public Decs(SourceLocation location, Dec child1, Dec child2) {
        this(location, new Dec[]{child1, child2});
    }

    public Decs(SourceLocation location, Dec child1, Dec child2, Dec child3) {
        this(location, new Dec[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        Dec[] copiedChildren = new Dec[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            Dec newChild = (Dec)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        Decs ret = new Decs(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (Dec)child);
    }

    public String getChildNameAt(int childIndex) {
        return "dec" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public Dec get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, Dec child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            Dec[] newChildren = new Dec[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(Decs collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, Decs collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(Dec child) {
        this.add(this.size, child);
    }

    public void add(int index, Dec child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "Decs()";
    }
}

