/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.RealType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public final class DoubleType
extends RealType {
    protected boolean isAssignableFromOtherType(Type other) {
        return other instanceof NumericType;
    }

    public String getName() {
        return "double";
    }

    public int getTypeIndex() {
        return 7;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Double");
    }

    public Expr getNullExpr() {
        return this.getAST().makeLiteral(0.0);
    }

    public DoubleType(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDescriptor() {
        return "D";
    }

    public int getSlotCount() {
        return 2;
    }

    private LiteralExpr makeLit(double d) {
        return this.getAST().makeLiteral(d);
    }

    private LiteralExpr makeBooleanLit(boolean b) {
        return this.getAST().makeLiteral(b);
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return this.makeLit(rand.getDoubleValue());
    }

    strictfp LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.makeLit(rand.getDoubleValue());
    }

    strictfp LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.makeLit(-rand.getDoubleValue());
    }

    strictfp LiteralExpr foldAddOp(LiteralExpr rand1, LiteralExpr rand2) {
        return this.makeLit(rand1.getDoubleValue() + rand2.getDoubleValue());
    }

    strictfp LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        double a = lit1.getDoubleValue();
        double b = lit2.getDoubleValue();
        if (op == "-") {
            return ast.makeLiteral(a - b);
        }
        if (op == "%") {
            return ast.makeLiteral(a % b);
        }
        if (op == "/") {
            return ast.makeLiteral(a / b);
        }
        if (op == "*") {
            return ast.makeLiteral(a * b);
        }
        throw new RuntimeException("bad numeric op " + op);
    }

    LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        double a = lit1.getDoubleValue();
        double b = lit2.getDoubleValue();
        if (op == "==") {
            return ast.makeLiteral(a == b);
        }
        if (op == "!=") {
            return ast.makeLiteral(a != b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        double a = lit1.getDoubleValue();
        double b = lit2.getDoubleValue();
        if (op == "<") {
            return ast.makeLiteral(a < b);
        }
        if (op == "<=") {
            return ast.makeLiteral(a <= b);
        }
        if (op == ">=") {
            return ast.makeLiteral(a >= b);
        }
        if (op == ">") {
            return ast.makeLiteral(a > b);
        }
        throw new RuntimeException("bad op " + op);
    }

    void emitAdd(CodeBuilder cb) {
        cb.emitDADD();
    }

    void emitNumericOp(CodeBuilder cb, String op) {
        if (op == "-") {
            cb.emitDSUB();
        } else if (op == "%") {
            cb.emitDREM();
        } else if (op == "/") {
            cb.emitDDIV();
        } else if (op == "*") {
            cb.emitDMUL();
        }
    }

    void emitNeg(CodeBuilder cb) {
        cb.emitDNEG();
    }

    public void emitLoad(CodeBuilder cb, int loc) {
        cb.emitDLOAD(loc);
    }

    public void emitStore(CodeBuilder cb, int loc) {
        cb.emitDSTORE(loc);
    }

    public void emitReturn(CodeBuilder cb) {
        cb.emitDRETURN();
    }

    void emitCast(CodeBuilder cb, Type castTo) {
        ((NumericType)castTo).emitCastFromDouble(cb);
    }

    void emitCastFromInt(CodeBuilder cb) {
        cb.emitI2D();
    }

    void emitCastFromFloat(CodeBuilder cb) {
        cb.emitF2D();
    }

    void emitCastFromLong(CodeBuilder cb) {
        cb.emitL2D();
    }

    void emitCastFromDouble(CodeBuilder cb) {
    }

    void emitPop(CodeBuilder cb) {
        cb.emitPOP2();
    }

    void emitDup(CodeBuilder cb) {
        cb.emitDUP2();
    }

    void emitDupX1(CodeBuilder cb) {
        cb.emitDUP2_X1();
    }

    void emitDupX2(CodeBuilder cb) {
        cb.emitDUP2_X2();
    }

    void emitZero(CodeBuilder cb) {
        cb.emitDoubleConstant(0.0);
    }

    void emitOne(CodeBuilder cb) {
        cb.emitDoubleConstant(1.0);
    }

    void emitMinusOne(CodeBuilder cb) {
        cb.emitDoubleConstant(-1.0);
    }

    void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        cb.emitDCMPL();
        if (op == "==") {
            cb.emitIFEQ(t, f);
        } else if (op == "!=") {
            cb.emitIFNE(t, f);
        }
    }

    void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "<") {
            cb.emitDCMPG();
            cb.emitIFLT(t, f);
        } else if (op == "<=") {
            cb.emitDCMPG();
            cb.emitIFLE(t, f);
        } else if (op == ">=") {
            cb.emitDCMPL();
            cb.emitIFGE(t, f);
        } else if (op == ">") {
            cb.emitDCMPL();
            cb.emitIFGT(t, f);
        }
    }

    void emitAload(CodeBuilder cb) {
        cb.emitDALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitDASTORE();
    }
}

