/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ByteType;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.ExprStmt;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.ForStmt;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.ReferenceExpr;
import org.aspectj.compiler.base.ast.ShortType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public abstract class Expr
extends ASTObject {
    protected Type type;

    public boolean isInConstructorCallExpr() {
        ASTObject e = this;
        while (true) {
            if (e instanceof ConstructorCallExpr) {
                return true;
            }
            if (!(e instanceof Expr)) break;
            e = e.getParent();
        }
        return false;
    }

    public boolean isConstantZero() {
        return false;
    }

    public boolean isConstantTrue() {
        return false;
    }

    public boolean isConstantFalse() {
        return false;
    }

    public boolean isAssignableTo(Type type) {
        return type.isAssignableFrom(this.getType());
    }

    public final boolean isMethodConvertableTo(Type type) {
        return type.isAssignableFrom(this.getType());
    }

    public boolean isLegalStmt() {
        return false;
    }

    public ASTObject postCopy(CopyWalker walker, ASTObject oldObject) {
        if (this.type == null) {
            this.type = ((Expr)oldObject).type;
        }
        return super.postCopy(walker, oldObject);
    }

    protected Expr makeQualifiedThis(Type declaringType) {
        if (this.getLexicalType() != null && this.getLexicalType().isInnerType()) {
            return this.getAST().makeQualifiedThis(declaringType);
        }
        return this.getAST().makeThis(declaringType);
    }

    public boolean isInExprStmt() {
        ASTObject parent = this.getParent();
        if (parent instanceof ExprStmt) {
            return true;
        }
        if (parent instanceof Exprs) {
            ASTObject grandparent = parent.getParent();
            return grandparent instanceof ForStmt;
        }
        return false;
    }

    public void checkSpec() {
        if (this.type == null) {
            this.type = this.discoverType();
        }
    }

    public void assertType(Type type) {
        if (!type.isAssignableFrom(this.getType())) {
            this.showTypeError(this.getType(), type);
        }
    }

    public Type getType() {
        if (this.type == null) {
            this.type = this.discoverType();
        }
        if (this.type == null) {
            // empty if block
        }
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void showOperatorTypeError(String op, Type a, Type b) {
        if (a.isMissing() || b.isMissing()) {
            return;
        }
        this.showError("operator " + op + " cannot be applied to " + a.getString() + "," + b.getString());
    }

    public void showOperatorTypeError(String op, Type a) {
        if (a.isMissing()) {
            return;
        }
        this.showError("operator " + op + " cannot be applied to " + a.getString());
    }

    public Expr makeReference() {
        return new ReferenceExpr(this.getSourceLocation(), this);
    }

    public boolean canBeCopied() {
        return false;
    }

    public boolean isUltimatelyLiteral() {
        return false;
    }

    protected abstract Type discoverType();

    public void cleanup() {
        this.type = null;
        super.cleanup();
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
    }

    protected void cgValue(CodeBuilder cb) {
        Label trueLab = cb.genLabel();
        Label falseLab = cb.genLabel();
        Label endLab = cb.genLabel();
        this.cgTest(cb, trueLab, falseLab);
        cb.emitLabel(trueLab);
        cb.emitIntConstant(1);
        cb.emitJump(endLab);
        cb.emitLabel(falseLab);
        cb.popStack(1);
        cb.emitIntConstant(0);
        cb.emitLabel(endLab);
    }

    protected void cgValue(CodeBuilder cb, Type castTo) {
        this.cgValue(cb);
        this.getType().emitCast(cb, castTo);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValue(cb);
        this.getType().emitPop(cb);
    }

    protected void cgBuffer(CodeBuilder cb) {
        this.cgValue(cb);
        NameType stringBufferType = this.getTypeManager().getStringBufferType();
        Type ty = this.getType();
        if (ty instanceof ByteType || ty instanceof ShortType) {
            ty = this.getTypeManager().intType;
        } else if (!ty.isString() && ty instanceof RefType) {
            ty = this.getTypeManager().getObjectType();
        }
        cb.emitINVOKEVIRTUAL(stringBufferType, "append", "(" + ty.getDescriptor() + ")Ljava/lang/StringBuffer;", -ty.getSlotCount());
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        this.cgValue(cb);
        cb.emitIFNE(tdest, fdest);
    }

    public void walkFrameLoc(FrameLocPass walker) {
    }

    public Expr(SourceLocation location) {
        super(location);
    }

    public String getDefaultDisplayName() {
        return "Expr()";
    }
}

