/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BasicAssignExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.QualifiedThisExpr;
import org.aspectj.compiler.base.ast.SOLink;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.AccessFixer;

public class FieldAccessExpr
extends AssignableExpr
implements SOLink {
    protected Expr expr;
    protected Field field;
    protected boolean isSuper;

    public FieldDec getFieldDec() {
        return (FieldDec)this.field.getCorrespondingDec();
    }

    protected Type discoverType() {
        return this.field.getFieldType();
    }

    public void walkFlow(FlowCheckerPass w) {
        Expr e = this.getExpr();
        FieldDec dec = this.getFieldDec();
        if (e != null) {
            w.process(e);
        }
        if (dec.isFinal() && this.isBare() && w.isCurrent(dec) && !w.getVars().isDefinitelyAssigned(dec)) {
            this.showError("Field " + this.getId() + " might not have a value");
        }
    }

    public boolean isBare() {
        Expr e = this.getExpr();
        if (e == null) {
            return true;
        }
        if (this.getField().isStatic()) {
            return e instanceof TypeExpr && e.isSynthetic();
        }
        return e instanceof ThisExpr || e instanceof QualifiedThisExpr && e.isSynthetic();
    }

    public void postInnerInfo(InnerInfoPass w) {
        if (this.expr == null) {
            w.checkStaticAccess(this, this.field);
        }
        if (this.expr == null) {
            this.setExpr(this.getAST().makePrimary((SemanticObject)this.getField(), w.currentType()));
        }
    }

    public boolean hasLegalProtectedAccess(Type fromType) {
        if (this.expr == null || this.getIsSuper()) {
            return true;
        }
        return this.expr.getType().isSubtypeOf(fromType);
    }

    public void checkSpec() {
        if (this.field == null) {
            return;
        }
        if (this.field.getModifiers().isProtected() && !this.field.isAccessible(this)) {
            this.showError(this.field.toShortString() + " has protected access");
        }
        if (this.expr instanceof TypeExpr && !this.field.isStatic()) {
            this.showError("non-static field " + this.field.toShortString() + " cannot be accessed through a static reference");
        }
    }

    public void walkForwardReference(ForwardReferenceChecker w) {
        super.walkForwardReference(w);
        if (this.isLhs() && this.getParent() instanceof BasicAssignExpr) {
            return;
        }
        if (this.getExpr() != null && !this.getExpr().isSynthetic()) {
            return;
        }
        w.checkReference(this);
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        if (this.isLhs()) {
            return this;
        }
        Field field = this.getField();
        FieldDec fieldDec = this.getFieldDec();
        fieldDec.ensureFolded(walker);
        Expr initExpr = fieldDec.getInitializer();
        if (fieldDec.isConstant() && this.isLegalConstantPrimary(this.getExpr())) {
            return fieldDec.getType().foldCast((LiteralExpr)initExpr).setSource(this);
        }
        return this;
    }

    private boolean isLegalConstantPrimary(Expr expr) {
        if (expr == null) {
            return true;
        }
        if (expr instanceof ParenExpr) {
            return this.isLegalConstantPrimary(((ParenExpr)expr).getExpr());
        }
        if (expr instanceof TypeExpr) {
            return true;
        }
        if (expr.isSynthetic() || !expr.fromSource()) {
            return expr instanceof ThisExpr;
        }
        return false;
    }

    public ASTObject fixAccessPost(AccessFixer fixer) {
        if (this.isLhs()) {
            return this;
        }
        Field field = this.getField();
        if (field == null) {
            return this;
        }
        if (field.isAccessible(this, true)) {
            return this;
        }
        this.getCompiler().showMessage("  fixing privileged get: " + field.toShortString());
        Method method = field.getBackdoorGetterMethod();
        if (!fixer.apply) {
            return this;
        }
        return this.getAST().makeCall(method, this.getExpr()).setSource(this);
    }

    public FieldAccessExpr(SourceLocation source, Type type, String name) {
        this(source, null, type.getField(name, null, true), false);
    }

    public FieldAccessExpr(SourceLocation source, Expr expr, String name) {
        this(source, expr, expr.getType().getField(name, expr, true), false);
    }

    public String getId() {
        return this.getField().getId();
    }

    public ASTObject postMove(MovingWalker walker) {
        return walker.moveLinkExpr(this);
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        this.setExpr(this.field.updateTargetExpr(this.getExpr()));
        if (!this.isLhs() && this.getField().getDeclaringType().isInterface() && !this.getField().isStatic()) {
            return this.getAST().makeCall(this.getField().getBackdoorGetterMethod(), this.getExpr());
        }
        return this;
    }

    public SemanticObject getTarget() {
        return this.getField();
    }

    public void setTarget(SemanticObject newTarget) {
        this.setField((Field)newTarget);
    }

    public Type getTargetType() {
        Type declaringType = this.getField().getDeclaringType();
        if (declaringType.isInterface() && !this.getOptions().strict) {
            return declaringType;
        }
        if (this.expr != null) {
            declaringType = this.expr.getType();
        }
        return declaringType;
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.expr);
        writer.write('.');
        writer.write(this.getField().getBytecodeId());
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        if (this.isLhs()) {
            return this;
        }
        Expr q = this.getExpr();
        FieldDec dec = this.getFieldDec();
        if (w.isAccessible(dec, q)) {
            return this;
        }
        AST ast = this.getAST();
        Type qType = q.getType();
        MethodDec newMethodDec = w.getAccessMethod(qType, dec, "x", this);
        Exprs newArgs = ast.makeExprs();
        Expr newExpr = w.makeOutsidePrimary(dec.isStatic(), newArgs, q);
        return ast.makeCall(newMethodDec, newExpr, newArgs);
    }

    public MethodDec buildAccessMethod(InnerAccessFixer w) {
        AST ast = this.getAST();
        Expr q = this.getExpr();
        Type qType = q.getType();
        FieldDec dec = this.getFieldDec();
        Type fieldType = dec.getType();
        Formals newFormals = ast.makeFormals();
        Expr newExpr = w.makeInsidePrimary(dec.isStatic(), newFormals, qType);
        return w.makeAccessMethod(fieldType, newFormals, ast.makeGet(newExpr, dec));
    }

    protected void cgLvalue(CodeBuilder cb) {
        if (this.field.isStatic() || this.field.isConstant()) {
            this.expr.cgEffect(cb);
        } else {
            this.expr.cgValue(cb);
        }
    }

    protected void cgLtoRvalue(CodeBuilder cb) {
        if (this.expr.getType() instanceof ArrayType) {
            cb.emitARRAYLENGTH();
        } else {
            NameType qualifyingType = (NameType)this.getTargetType();
            String name = this.field.getBytecodeId();
            String descriptor = this.field.getDescriptor();
            int delta = this.getType().getSlotCount();
            if (this.field.isConstant()) {
                this.field.getFieldDec().getInitializer().cgValue(cb);
            } else if (this.field.isStatic()) {
                cb.emitGETSTATIC(qualifyingType, name, descriptor, delta);
            } else {
                cb.emitGETFIELD(qualifyingType, name, descriptor, delta - 1);
            }
        }
    }

    protected void cgAssignment(CodeBuilder cb) {
        NameType qualifyingType = (NameType)this.getTargetType();
        String name = this.field.getBytecodeId();
        String descriptor = this.field.getDescriptor();
        int delta = this.getType().getSlotCount();
        if (this.field.isStatic()) {
            cb.emitPUTSTATIC(qualifyingType, name, descriptor, -delta);
        } else {
            cb.emitPUTFIELD(qualifyingType, name, descriptor, -delta - 1);
        }
    }

    protected void cgDupLvalue(CodeBuilder cb) {
        if (!this.field.isStatic()) {
            cb.emitDUP();
        }
    }

    protected void cgDupRvalue(CodeBuilder cb) {
        if (this.field.isStatic()) {
            this.getType().emitDup(cb);
        } else {
            this.getType().emitDupX1(cb);
        }
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field _field) {
        this.field = _field;
    }

    public boolean getIsSuper() {
        return this.isSuper;
    }

    public void setIsSuper(boolean _isSuper) {
        this.isSuper = _isSuper;
    }

    public FieldAccessExpr(SourceLocation location, Expr _expr, Field _field, boolean _isSuper) {
        super(location);
        this.setExpr(_expr);
        this.setField(_field);
        this.setIsSuper(_isSuper);
    }

    protected FieldAccessExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        FieldAccessExpr ret = new FieldAccessExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        ret.field = this.field;
        ret.isSuper = this.isSuper;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "FieldAccessExpr(field: " + this.field + ", " + "isSuper: " + this.isSuper + ")";
    }
}

