/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TestStmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class IfStmt
extends TestStmt {
    protected Expr test;
    protected Stmt then;
    protected Stmt _else;

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("if");
        writer.optionalSpace();
        writer.parenExpr(this.test);
        writer.optionalSpace();
        writer.write(this.then);
        if (!(this._else instanceof EmptyStmt) || !this._else.isSynthetic()) {
            writer.writeKeyword("else");
            writer.optionalSpace();
            writer.write(this._else);
        }
    }

    public void checkSpec() {
        this.then.requireStmt();
        if (this._else != null) {
            this._else.requireStmt();
        }
        super.checkSpec();
    }

    public void walkFlow(FlowCheckerPass w) {
        w.processBoolean(this.getTest());
        FlowCheckerPass.Vars p0 = w.getVars();
        w.setVars(p0.getTrue());
        w.process(this.getThen());
        FlowCheckerPass.Vars v0 = w.getVars();
        boolean trueLive = w.isLive();
        w.setLive(true);
        w.setVars(p0.getFalse());
        w.process(this.getElse());
        FlowCheckerPass.Vars v1 = w.getVars();
        boolean falseLive = w.isLive();
        w.setLive(falseLive || trueLive);
        w.setVars(v0.join(v1));
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantTrue()) {
            w.process(this.getThen());
        } else if (this.getTest().isConstantFalse()) {
            w.process(this.getElse());
        } else {
            w.setLive(true);
            this.setThen((Stmt)w.process(this.getThen()));
            boolean thenLive = w.isLive();
            w.setLive(true);
            this.setElse((Stmt)w.process(this.getElse()));
            w.setLive(thenLive || w.isLive());
        }
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantTrue()) {
            return this.getThen();
        }
        if (this.getTest().isConstantFalse()) {
            return this.getElse();
        }
        if (this.getThen() instanceof EmptyStmt && this.getElse() instanceof EmptyStmt) {
            return this.getAST().makeStmt(this.getTest()).setSource(this);
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label trueLab = cb.genLabel();
        Label falseLab = cb.genLabel();
        Label endLab = cb.genLabel();
        this.getTest().cgTest(cb, trueLab, falseLab);
        cb.emitLabel(trueLab);
        this.getThen().cgTop(cb);
        if (this.getThen().completesNormally()) {
            cb.emitJump(endLab);
        }
        cb.emitLabel(falseLab);
        this.getElse().cgTop(cb);
        cb.emitLabel(endLab);
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public Stmt getThen() {
        return this.then;
    }

    public void setThen(Stmt _then) {
        if (_then != null) {
            _then.setParent(this);
        }
        this.then = _then;
    }

    public Stmt getElse() {
        return this._else;
    }

    public void setElse(Stmt __else) {
        if (__else != null) {
            __else.setParent(this);
        }
        this._else = __else;
    }

    public IfStmt(SourceLocation location, Expr _test, Stmt _then, Stmt __else) {
        super(location);
        this.setTest(_test);
        this.setThen(_then);
        this.setElse(__else);
    }

    protected IfStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        IfStmt ret = new IfStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        if (this.then != null) {
            ret.setThen((Stmt)walker.process(this.then));
        }
        if (this._else != null) {
            ret.setElse((Stmt)walker.process(this._else));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.test;
            }
            case 1: {
                return this.then;
            }
            case 2: {
                return this._else;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "test";
            }
            case 1: {
                return "then";
            }
            case 2: {
                return "else";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTest((Expr)child);
                return;
            }
            case 1: {
                this.setThen((Stmt)child);
                return;
            }
            case 2: {
                this.setElse((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "IfStmt()";
    }
}

