/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.cst.Name;
import org.aspectj.compiler.base.cst.Scope;

public class Import
extends ASTObject {
    private Type myType = null;
    protected Name typeName;
    protected boolean star;

    public void checkSpec() {
        if (!this.getStar()) {
            this.getType();
        }
    }

    public boolean capturesId(String id) {
        return this.typeName.getId().equals(id);
    }

    public Scope makeTypeNameScope() {
        return new Scope(this.getCompiler(), null){

            public Type findType(String name, ASTObject fromWhere) {
                return this.getTypeManager().findType(null, name);
            }

            public Expr bindUnqualifiedName(String name, ASTObject fromWhere) {
                return null;
            }
        };
    }

    public Type getType() {
        if (this.myType == null) {
            this.myType = this.typeName.resolveType(this.makeTypeNameScope());
            if (this.myType == null) {
                this.showError("type not found");
            } else if (this.getOptions().strict && this.myType.getPackageName() == null) {
                this.showError("import from default package not allowed");
            }
        }
        return this.myType;
    }

    public String getName() {
        return this.typeName.toString();
    }

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("import");
        writer.requiredSpace();
        writer.write(this.typeName.toString());
        if (this.star) {
            writer.write(".*");
        }
        writer.closeStmt();
        writer.newLine();
    }

    public Name getTypeName() {
        return this.typeName;
    }

    public void setTypeName(Name _typeName) {
        this.typeName = _typeName;
    }

    public boolean getStar() {
        return this.star;
    }

    public void setStar(boolean _star) {
        this.star = _star;
    }

    public Import(SourceLocation location, Name _typeName, boolean _star) {
        super(location);
        this.setTypeName(_typeName);
        this.setStar(_star);
    }

    protected Import(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        Import ret = new Import(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.typeName = this.typeName;
        ret.star = this.star;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "Import(typeName: " + this.typeName + ", " + "star: " + this.star + ")";
    }
}

