/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public final class IntType
extends IntishType {
    protected boolean isAssignableFromOtherType(Type other) {
        return other instanceof IntishType;
    }

    public String getName() {
        return "int";
    }

    public int getTypeIndex() {
        return 10;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Integer");
    }

    public IntType(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDescriptor() {
        return "I";
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return this.getAST().makeLiteral(rand.getIntValue());
    }

    void emitCastFromInt(CodeBuilder cb) {
    }

    void emitCastFromFloat(CodeBuilder cb) {
        cb.emitF2I();
    }

    void emitCastFromLong(CodeBuilder cb) {
        cb.emitL2I();
    }

    void emitCastFromDouble(CodeBuilder cb) {
        cb.emitD2I();
    }

    void emitAload(CodeBuilder cb) {
        cb.emitIALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitIASTORE();
    }

    boolean hasFastIncOp(Expr lhs, int rhs) {
        return lhs instanceof VarExpr && Short.MIN_VALUE <= rhs && rhs <= Short.MAX_VALUE;
    }

    void emitFastIncOp(CodeBuilder cb, Expr lhs, int rhs) {
        cb.emitIINC(((VarExpr)lhs).getVarDec().getFrameLoc(), rhs);
    }
}

