/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class LabeledStmt
extends Stmt {
    protected String label;
    protected Stmt stmt;

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.label);
        writer.write(": ");
        writer.write(this.stmt);
    }

    public void requireStmt() {
        this.showError("labeled statement not allowed here");
    }

    public void checkSpec() {
        if (!(this.stmt instanceof LabeledStmt)) {
            this.stmt.requireStmt();
        }
        super.checkSpec();
    }

    public void walkFlow(FlowCheckerPass w) {
        if (w.isLabelUsed(this.getLabel())) {
            this.showError("duplicate definition of label " + this.getLabel());
        }
        w.enterContext(this);
        w.process(this.getStmt());
        w.leaveContext();
        w.setLive(w.isLive() || w.isBroken(this));
        w.setVars(w.getVars().join(w.getBreakVars(this)));
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        w.enterContext(this);
        w.process(this.getStmt());
        w.leaveContext();
        w.setLive(w.isLive() || w.isBroken(this));
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        if (this.getStmt() instanceof EmptyStmt) {
            return this.getStmt();
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label endLab = cb.genLabel();
        cb.enterNonWindingContext(this, endLab, null);
        this.stmt.cgTop(cb);
        cb.leaveContext();
        cb.emitLabel(endLab);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String _label) {
        this.label = _label;
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public void setStmt(Stmt _stmt) {
        if (_stmt != null) {
            _stmt.setParent(this);
        }
        this.stmt = _stmt;
    }

    public LabeledStmt(SourceLocation location, String _label, Stmt _stmt) {
        super(location);
        this.setLabel(_label);
        this.setStmt(_stmt);
    }

    protected LabeledStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        LabeledStmt ret = new LabeledStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.label = this.label;
        if (this.stmt != null) {
            ret.setStmt((Stmt)walker.process(this.stmt));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.stmt;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "stmt";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setStmt((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "LabeledStmt(label: " + this.label + ")";
    }
}

