/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.UnopExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class LogNotOpExpr
extends UnopExpr {
    protected LiteralExpr halfFold(Type type, LiteralExpr lit) {
        return type.foldLogNotOp(lit);
    }

    protected Type discoverType() {
        if (!this.getRand1().getType().isBoolean()) {
            this.showOperatorTypeError(this.getRand1().getType());
        }
        return this.getTypeManager().booleanType;
    }

    protected Type getLiftType() {
        return this.getType();
    }

    public void walkFlow(FlowCheckerPass w) {
        w.processBoolean(this.getRand1());
        FlowCheckerPass.Vars p1 = w.getVars();
        w.setVars(p1.getFalse(), p1.getTrue());
    }

    public void normalizeFlow(FlowCheckerPass w) {
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        this.getRand1().cgTest(cb, fdest, tdest);
    }

    protected void cgValue(CodeBuilder cb) {
        this.getRand1().cgValue(cb);
        this.getTypeManager().booleanType.emitLogNot(cb);
    }

    public LogNotOpExpr(SourceLocation location, String _op, Expr _rand1) {
        super(location, _op, _rand1);
    }

    protected LogNotOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        LogNotOpExpr ret = new LogNotOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.op = this.op;
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "LogNotOpExpr(op: " + this.op + ")";
    }
}

