/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;

public class MethodDec
extends CodeDec {
    private Set matchingSignatureTypes = null;
    private MethodDec backdoorMethod;
    private String descriptor;
    private boolean isDeltaComputed = false;
    private int stackDelta;
    protected TypeD resultTypeD;
    protected String id;

    public MethodDec(SourceLocation source, Modifiers modifiers, TypeD resultTypeD, String id, Formals formals, TypeDs _throws, BlockStmt block) {
        this(source, modifiers, resultTypeD, id, formals, _throws, CodeDec.blockToBody(block));
    }

    public MethodDec(SourceLocation source, Modifiers modifiers, Type resultType, String id, Formals formals, TypeDs _throws, BlockStmt block) {
        this(source, modifiers, resultType.makeTypeD(), id, formals, _throws, CodeDec.blockToBody(block));
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (this.isIntroduced()) {
            this.getModifiers().setPublic(true);
        }
        if (this.getBytecodeTypeDec() instanceof InterfaceDec) {
            this.getModifiers().setValue(1025);
            this.setBody(null);
        }
        return this;
    }

    public ASTObject postImplementMixin(MixinImplementationPass fixer) {
        TypeDec inTypeDec = this.getBytecodeTypeDec();
        if (!(inTypeDec instanceof InterfaceDec)) {
            return this;
        }
        if (this.getBody() == null) {
            return this;
        }
        if (this.isStatic()) {
            ((InterfaceDec)inTypeDec).addToHelperClass(this);
            return null;
        }
        this.getModifiers().setFinal(false);
        this.getModifiers().setPublic(true);
        Set topmostImplementors = Type.filterTopTypes(Type.filterConcreteTypes(inTypeDec.getType().getSubTypes()));
        Iterator i = topmostImplementors.iterator();
        while (i.hasNext()) {
            Type implType = (Type)i.next();
            TypeDec implDec = implType.getTypeDec();
            if (!this.shouldImplement(implDec.getType(), this)) continue;
            MethodDec newDec = (MethodDec)fixer.copyToClass(this, implDec);
            implDec.getBody().add(newDec);
        }
        this.setBody(null);
        this.getModifiers().setSynchronized(false);
        return this;
    }

    boolean shouldImplement(Type onType, Dec dec) {
        Dec existingDec = onType.findMatchingDec(dec);
        if (existingDec != null && existingDec != dec) {
            return false;
        }
        Dec owner = dec.owner;
        if (owner != null) {
            return this.shouldImplement(onType, owner);
        }
        return true;
    }

    public void preScope(ScopeWalker walker) {
        walker.addMethodDec(this);
        super.preScope(walker);
    }

    public Expr getExpr() {
        return null;
    }

    public String toShortString() {
        return this.addIntroducedFromType(this.modifiers.toShortString() + " " + this.resultTypeD.toShortString() + " " + this.getDeclaringType().toShortString() + "." + this.id + this.formals.toShortString());
    }

    public String getKind() {
        return "method";
    }

    public SemanticObject makeCorrespondingSemanticObject() {
        return new Method(this);
    }

    public Method getMethod() {
        return (Method)this.getCorrespondingSemanticObject();
    }

    MethodDec makeSuperCaller() {
        AST ast = this.getAST();
        Modifiers modifiers = ast.makeModifiers(0);
        if (this.isProtected()) {
            modifiers.setProtected();
        }
        if (this.isPublic()) {
            modifiers.setPublic(true);
        }
        Type resultType = this.getResultType();
        Formals formals = (Formals)this.getFormals().copy();
        CallExpr superCall = ast.makeSuperCall(this.getMethod(), formals.makeExprs());
        Stmt stmt = resultType.isVoid() ? ast.makeStmt(superCall) : ast.makeReturn(superCall);
        MethodDec ret = ast.makeMethod(modifiers, resultType, this.getId(), formals, ast.makeBlock(stmt));
        if (this.getThrows() != null) {
            ret.setThrows((TypeDs)this.getThrows().copy());
        }
        return ret;
    }

    public void checkSpec() {
        super.checkSpec();
        if (this.getModifiers().isAbstract()) {
            if (this.getModifiers().isStrict()) {
                this.getModifiers().showError("illegal combination of modifiers: abstract strictfp");
            } else if (this.getModifiers().isPrivate()) {
                if (!this.isIntroduced()) {
                    this.showError("abstract private method can never be implemented");
                }
            } else if (this.getModifiers().isStatic()) {
                this.getModifiers().showError("illegal combination of modifiers: abstract static");
            }
        }
        if (this.isAbstract() || this.getModifiers().isNative()) {
            if (this.getBody() != null) {
                this.showError("abstract or native methods cannot have a body");
            }
        } else if (this.getBody() == null) {
            this.showError("non-abstract/native methods must have a body");
        }
    }

    void showOverrideError(Type inType, MethodDec other, String message) {
        if (this.getDeclaringType() != inType) {
            inType.getTypeDec().showError("inherited method " + this.toShortString() + " is incompatible with inherited method " + other.toShortString() + "; " + message);
        } else {
            String overrideKind = "override";
            if (other.getDeclaringType().isInterface()) {
                overrideKind = "implement";
            }
            this.showError(this.toShortString() + " cannot " + overrideKind + " " + other.toShortString() + "; " + message);
        }
    }

    public boolean isEffectivelyAbstract(Type inType) {
        return this.isAbstract() || inType.isInterface() && this.getDeclaringType().isObject();
    }

    public boolean checkOverride(Type inType, Dec otherDec) {
        MethodDec other = (MethodDec)otherDec;
        if (this.getDeclaringType() != inType) {
            if (this.isEffectivelyAbstract(inType)) {
                if (!other.isEffectivelyAbstract(inType)) {
                    other.internalCheckOverride(inType, this);
                    return true;
                }
                if (this.getModifiers().isWeakerThan(other.getModifiers())) {
                    other.internalCheckOverride(inType, this);
                    return true;
                }
                this.internalCheckOverride(inType, other);
                return false;
            }
            if (other.isEffectivelyAbstract(inType)) {
                this.internalCheckOverride(inType, other);
                return false;
            }
            if (this.overrides(other)) {
                this.internalCheckOverride(inType, other);
                return false;
            }
            if (other.overrides(this)) {
                other.internalCheckOverride(inType, this);
                return true;
            }
            this.showOverrideError(inType, other, "both methods are concrete");
            return false;
        }
        this.internalCheckOverride(inType, other);
        return false;
    }

    private void internalCheckOverride(Type inType, MethodDec other) {
        if (!this.getResultType().isEquivalent(other.getResultType())) {
            this.showOverrideError(inType, other, "attempting to use incompatible return type\nfound   : " + this.getResultType().getString() + "\n" + "required: " + other.getResultType().getString());
        } else if (other.getModifiers().isFinal()) {
            this.showOverrideError(inType, other, "overridden method is final");
        } else if (other.isStatic() && !this.isStatic()) {
            this.showOverrideError(inType, other, "overridden method is static");
        } else if (this.isStatic() && !other.isStatic()) {
            this.showOverrideError(inType, other, "overridden method is non-static");
        } else if (this.getModifiers().isWeakerThan(other.getModifiers())) {
            this.showOverrideError(inType, other, "attempting to assign weaker access privileges; was " + other.getModifiers().toShortString());
        } else if (this._throws != null) {
            int i = 0;
            while (i < this._throws.size()) {
                if (!other.canThrow(this._throws.get(i).getType())) {
                    this.showOverrideError(inType, other, "overridden method does not throw " + this._throws.get(i).getType().getString());
                    break;
                }
                ++i;
            }
        }
    }

    public boolean overrides(MethodDec other) {
        Iterator i = this.getDeclaringType().getDirectSuperTypes().iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next();
            MethodDec dec = (MethodDec)type.findMatchingDec(this);
            if (dec == null) continue;
            if (dec == other) {
                return true;
            }
            if (dec == this) {
                this.getCompiler().internalError(this, "nonsense");
                return false;
            }
            if (!dec.overrides(other)) continue;
            return true;
        }
        return false;
    }

    public Set getMatchingMethods() {
        HashSet<MethodDec> ret = new HashSet<MethodDec>();
        Iterator i = this.getDeclaringType().getSubTypes().iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next();
            MethodDec dec = (MethodDec)type.findMatchingDec(this);
            if (dec == null) continue;
            ret.add(dec);
        }
        return ret;
    }

    public Set getMatchingSignatureTypes() {
        if (this.matchingSignatureTypes == null) {
            HashSet s = new HashSet();
            this.addMatchingSignatureTypes(s, this.getDeclaringType());
        }
        return this.matchingSignatureTypes;
    }

    private void addMatchingSignatureTypes(Set s, Type myType) {
        if (s.contains(myType)) {
            if (this.matchingSignatureTypes != s) {
                this.getCompiler().internalError(this, "bad invariant in collecting matching signatures");
            }
            return;
        }
        this.matchingSignatureTypes = s;
        s.add(myType);
        this.addMatchingSignaturesIn(s, myType.getDirectSubTypes());
        this.addMatchingSignaturesIn(s, myType.getDirectSuperTypes());
    }

    private void addMatchingSignaturesIn(Set s, Collection types) {
        Iterator i = types.iterator();
        while (i.hasNext()) {
            Type type = (Type)i.next();
            MethodDec dec = (MethodDec)type.findMatchingDec(this);
            if (dec == null) continue;
            dec.addMatchingSignatureTypes(s, type);
        }
    }

    public MethodDec getBackdoorMethod() {
        if (this.backdoorMethod != null) {
            return this.backdoorMethod;
        }
        AST ast = this.getAST();
        String id = this.getBytecodeId() + "$ajc$backdoor";
        Modifiers modifiers = ast.makeModifiers(17);
        if (this.isStatic()) {
            modifiers.setStatic(true);
        }
        Formals formals = (Formals)this.getFormals().copy();
        Expr thisExpr = this.isStatic() ? ast.makeTypeExpr(this.getBytecodeTypeDec().getType()) : ast.makeThis(this.getBytecodeTypeDec().getType());
        CallExpr innerCall = ast.makeCall(this, thisExpr, formals.makeExprs());
        Stmt stmt = this.resultTypeD.getType().isEquivalent(this.getTypeManager().voidType) ? ast.makeStmt(innerCall) : ast.makeReturn(innerCall);
        MethodDec ret = ast.makeMethod(modifiers, this.getResultType(), id, formals, ast.makeBlock(stmt));
        ret.getBody().setParsed(true);
        if (this.getThrows() != null) {
            ret.setThrows((TypeDs)this.getThrows().copy());
        }
        this.getDeclaringType().getTypeDec().addToBody(ret);
        this.backdoorMethod = ret;
        return this.backdoorMethod;
    }

    public void unparse(CodeWriter writer) {
        if (this.getBytecodeTypeDec() instanceof InterfaceDec && (this.isPrivate() || this.isFinal())) {
            return;
        }
        this.writeModifiers(writer);
        writer.write(this.resultTypeD);
        writer.requiredSpace();
        writer.write(this.getBytecodeId());
        writer.write(this.formals);
        this.writeNames(writer, "throws", this.getThrows());
        if (!writer.isOnlySignatures()) {
            if (this.body == null) {
                writer.closeStmt();
            } else {
                writer.optionalSpace();
                writer.write(this.body);
            }
            writer.newLine();
        }
    }

    protected void cgCodeMember(CodeBuilder cb) {
        cb.setMaxFrame(this.getFrameSize());
        cb.enterBlock();
        Formals f = this.getFormals();
        int i = 0;
        int len = f.size();
        while (i < len) {
            cb.enterVar(f.get(i));
            ++i;
        }
        this.getBody().cgTop(cb);
        cb.exitBlock();
    }

    public synchronized String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = "(";
            Iterator i = this.getFormals().iterator();
            while (i.hasNext()) {
                FormalDec dec = (FormalDec)i.next();
                this.descriptor = this.descriptor + dec.getType().getDescriptor();
            }
            this.descriptor = this.descriptor + ")";
            this.descriptor = this.descriptor + this.getResultType().getDescriptor();
        }
        return this.descriptor;
    }

    public synchronized int getStackDelta() {
        if (!this.isDeltaComputed) {
            this.stackDelta = this.getResultType().getSlotCount();
            if (!this.isStatic()) {
                --this.stackDelta;
            }
            Iterator i = this.getFormals().iterator();
            while (i.hasNext()) {
                FormalDec dec = (FormalDec)i.next();
                this.stackDelta -= dec.getType().getSlotCount();
            }
            this.isDeltaComputed = true;
        }
        return this.stackDelta;
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
        walker.pushNonConstructorEnv();
    }

    public ASTObject postThreading(LocalClassPass.ThreadingWalker walker) {
        walker.popEnv();
        return this;
    }

    public TypeD getResultTypeD() {
        return this.resultTypeD;
    }

    public void setResultTypeD(TypeD _resultTypeD) {
        if (_resultTypeD != null) {
            _resultTypeD.setParent(this);
        }
        this.resultTypeD = _resultTypeD;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public MethodDec(SourceLocation location, Modifiers _modifiers, TypeD _resultTypeD, String _id, Formals _formals, TypeDs __throws, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _body);
        this.setResultTypeD(_resultTypeD);
        this.setId(_id);
    }

    protected MethodDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        MethodDec ret = new MethodDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.resultTypeD != null) {
            ret.setResultTypeD((TypeD)walker.process(this.resultTypeD));
        }
        ret.id = this.id;
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this._throws != null) {
            ret.setThrows((TypeDs)walker.process(this._throws));
        }
        if (this.body != null) {
            ret.setBody((CodeBody)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.resultTypeD;
            }
            case 2: {
                return this.formals;
            }
            case 3: {
                return this._throws;
            }
            case 4: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "resultTypeD";
            }
            case 2: {
                return "formals";
            }
            case 3: {
                return "throws";
            }
            case 4: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setResultTypeD((TypeD)child);
                return;
            }
            case 2: {
                this.setFormals((Formals)child);
                return;
            }
            case 3: {
                this.setThrows((TypeDs)child);
                return;
            }
            case 4: {
                this.setBody((CodeBody)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 5;
    }

    public String getDefaultDisplayName() {
        return "MethodDec(id: " + this.id + ")";
    }
}

