/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.ClassExpr;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.SemanticMap;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.ast.PointcutSO;

public class NameType
extends RefType {
    final SemanticMap fields = new SemanticMap(this, "field");
    final SemanticMap pointcuts = new SemanticMap(this, "pointcut");
    final SemanticMap innerTypes = new SemanticMap(this, "type");
    final SemanticMap methods = new SemanticMap(this, "method");
    final SemanticMap constructors = new SemanticMap(this, "constructor");
    private boolean builtTypeGraph = false;
    private boolean builtSignatures = false;
    private boolean isLazy = true;
    private String internalName;
    private String descriptor;

    public NameType(TypeDec typeDec) {
        super(typeDec.getCompiler());
        this.dec = typeDec;
    }

    public TypeDec getTypeDec() {
        return (TypeDec)this.dec;
    }

    public boolean isCoercableTo(Type other) {
        if (this.isAssignableFrom(other)) {
            return true;
        }
        if (other.isAssignableFrom(this)) {
            return true;
        }
        if (!(other instanceof NameType)) {
            return false;
        }
        if (!this.isInterface() && !other.isInterface()) {
            return false;
        }
        if (this.isInterface() && other.isInterface()) {
            return this.methodsCompatibleWith(other);
        }
        if (this.isInterface()) {
            return !((NameType)other).isFinal();
        }
        if (other.isInterface()) {
            return !this.isFinal();
        }
        return false;
    }

    private boolean methodsCompatibleWith(Type other) {
        Iterator i = this.getMethods().iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            Method mOther = (Method)other.findMatchingSemanticObject(m);
            if (mOther == null || m.getReturnType().isEquivalent(mOther.getReturnType())) continue;
            return false;
        }
        return true;
    }

    public boolean dominates(Type other) {
        TypeDec t1 = this.getTypeDec();
        TypeDec t2 = other.getTypeDec();
        if (t2 != null && t1 instanceof AspectDec && t2 instanceof AspectDec) {
            return ((AspectDec)t1).dominates((AspectDec)t2);
        }
        return super.dominates(other);
    }

    public boolean isEffectivelyStatic() {
        return this.isStatic() || this.isPackageMember();
    }

    public Expr getClassExpr() {
        if (!this.getTypeDec().hasGlobalName()) {
            return this.getAST().makeNull();
        }
        return new ClassExpr(this.getAST().getSourceLocation(), this.makeTypeD());
    }

    public Expr makeObject(Expr expr) {
        return expr;
    }

    public Expr fromObject(Expr expr) {
        return this.getAST().makeCast(this, expr);
    }

    public Expr getNullExpr() {
        return this.getAST().makeNull();
    }

    public Type getRefType() {
        return this;
    }

    public Type getOutermostType() {
        return this.getTypeDec().getOutermostType();
    }

    public PointcutSO getPointcut(String id, ASTObject fromWhere, boolean showError) {
        this.ensureFinishedSignature();
        return (PointcutSO)this.pointcuts.get(id, fromWhere, null, showError);
    }

    public Field getField(String id, ASTObject fromWhere, boolean showError) {
        this.ensureFinishedSignature();
        return (Field)this.fields.get(id, fromWhere, null, showError);
    }

    public Type getInnerType(String id, ASTObject fromWhere, boolean showError) {
        this.ensureBuiltTypeGraph();
        Type ret = (Type)this.innerTypes.get(id, fromWhere, null, showError);
        return ret;
    }

    public Method getMethod(String id, ASTObject fromWhere, Exprs params, boolean showError) {
        this.ensureFinishedSignature();
        Method ret = (Method)this.methods.get(id, fromWhere, params, showError);
        return ret;
    }

    public boolean hasMethodNamed(String id) {
        this.ensureFinishedSignature();
        return this.methods.hasName(id);
    }

    public Constructor getConstructor(ASTObject fromWhere, Exprs params, boolean showError) {
        this.ensureFinishedSignature();
        return (Constructor)this.constructors.get("new", fromWhere, params, showError);
    }

    public SemanticObject findMatchingSemanticObject(SemanticObject o) {
        if (o instanceof Method) {
            return this.methods.findMatchingSemanticObject(o);
        }
        if (o instanceof Constructor) {
            return this.constructors.findMatchingSemanticObject(o);
        }
        if (o instanceof Field) {
            return this.fields.findMatchingSemanticObject(o);
        }
        return null;
    }

    private void addInheritedMembers(SemanticMap map, Collection bag) {
        Iterator i = map.getAllSemanticObjects().iterator();
        while (i.hasNext()) {
            SemanticObject so = (SemanticObject)i.next();
            if (so.getDeclaringType() == this) continue;
            bag.add(so);
        }
    }

    public Collection getInheritedMethods() {
        LinkedList ret = new LinkedList();
        this.addInheritedMembers(this.methods, ret);
        return ret;
    }

    public Collection getInheritedMembers() {
        LinkedList ret = new LinkedList();
        this.addInheritedMembers(this.methods, ret);
        this.addInheritedMembers(this.innerTypes, ret);
        this.addInheritedMembers(this.fields, ret);
        this.addInheritedMembers(this.pointcuts, ret);
        return ret;
    }

    public Collection getConstructors() {
        return this.constructors.getAllSemanticObjects();
    }

    public Collection getMethods() {
        return this.methods.getAllSemanticObjects();
    }

    public Collection getFields() {
        return this.fields.getAllSemanticObjects();
    }

    public Collection getPointcuts() {
        return this.pointcuts.getAllSemanticObjects();
    }

    public void addPointcut(PointcutDec pointcut) {
        this.pointcuts.addDeclared(pointcut.getCorrespondingSemanticObject());
    }

    public void addField(FieldDec field) {
        this.fields.addDeclared(field.getCorrespondingSemanticObject());
    }

    public void addMethod(MethodDec method) {
        this.methods.addDeclared(method.getCorrespondingSemanticObject());
    }

    public void addConstructor(ConstructorDec constructor) {
        this.constructors.addDeclared(constructor.getCorrespondingSemanticObject());
    }

    public NameType getSuperClassType() {
        return (NameType)this.getTypeDec().getSuperClassType();
    }

    public Type getDeclaringType() {
        return this.getTypeDec().getDeclaringType();
    }

    public void addInnerType(TypeDec type) {
        this.innerTypes.addDeclared(type.getType());
    }

    public Collection getInheritedFromTypes() {
        return this.directSuperTypes;
    }

    private void initializeInheritedTypeMap() {
        Iterator i = this.getInheritedFromTypes().iterator();
        while (i.hasNext()) {
            NameType superType = (NameType)i.next();
            superType.ensureBuiltTypeGraph();
            this.innerTypes.addInherited(superType.innerTypes);
        }
    }

    private void handleInheritedMembers(NameType superType) {
        superType.ensureFinishedSignature();
        this.pointcuts.addInherited(superType.pointcuts);
        this.fields.addInherited(superType.fields);
        this.methods.addInherited(superType.methods);
    }

    private void handleInheritedMembers() {
        NameType superClassType = this.getSuperClassType();
        if (superClassType != null && this.getInheritedFromTypes().contains(superClassType)) {
            this.handleInheritedMembers(superClassType);
        }
        Iterator i = this.getInheritedFromTypes().iterator();
        while (i.hasNext()) {
            NameType superType = (NameType)i.next();
            if (superType == superClassType) continue;
            this.handleInheritedMembers(superType);
        }
    }

    public String getPrettyString() {
        String prettyString = null;
        if (prettyString != null) {
            return prettyString;
        }
        prettyString = this.getLegalString().replace('$', '.');
        return prettyString;
    }

    private String makeLegalString() {
        return this.getTypeDec().getFullName();
    }

    public String getLegalString() {
        return this.makeLegalString();
    }

    public String getSourceString() {
        TypeDec typeDec = this.getTypeDec();
        return this.getPrettyString();
    }

    public String getString() {
        return this.getSourceString();
    }

    public String getExtendedId() {
        return this.getTypeDec().getExtendedId();
    }

    public String getId() {
        return this.getTypeDec().getId();
    }

    public String getExternalName() {
        return this.getClassName();
    }

    public String getClassName() {
        return this.getTypeDec().getFullName();
    }

    public String getPackageName() {
        return this.getTypeDec().getPackageName();
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.getSourceString());
    }

    public String toShortString() {
        String ret = this.getTypeDec().getSourceExtendedId();
        return ret;
    }

    public String toString() {
        return "NameType(" + this.getPrettyString() + ")";
    }

    public boolean isInterface() {
        return this.getTypeDec() instanceof InterfaceDec;
    }

    public boolean isClass() {
        return this.getTypeDec() instanceof ClassDec;
    }

    public boolean isAspect() {
        return this.getTypeDec() instanceof AspectDec;
    }

    public boolean isInnerType() {
        return this.getTypeDec().isInnerType();
    }

    public boolean isAnonymous() {
        return this.getTypeDec().isLocallyDefined();
    }

    public boolean isAbstract() {
        return this.isInterface() || this.getTypeDec().isAbstract();
    }

    public boolean isFinal() {
        return this.getTypeDec().isFinal();
    }

    public void ensureNoAbstractDecs() {
        this.pointcuts.ensureNoAbstracts();
        this.methods.ensureNoAbstracts();
    }

    public synchronized void ensureBuiltTypeGraph() {
        if (this.builtTypeGraph) {
            return;
        }
        this.getTypeDec().addToTypeGraph();
    }

    public synchronized void ensureFinishedSignature() {
        if (this.builtSignatures) {
            return;
        }
        this.ensureBuiltTypeGraph();
        this.getTypeDec().buildSignatures();
    }

    public void addToTypeGraph() {
        if (this.builtTypeGraph) {
            this.getCompiler().internalError("already built type graph " + this.getPrettyString());
            return;
        }
        this.builtTypeGraph = true;
        this.getCompiler().showMessage("  building type graph " + this.getPrettyString());
        if (this != this.getTypeManager().getObjectType()) {
            this.addDirectSuperType(this.getTypeDec().getSuperClassType());
        }
        Iterator i = this.getTypeDec().getSuperInterfaceTypes().iterator();
        while (i.hasNext()) {
            NameType superInterfaceType = (NameType)i.next();
            this.addDirectSuperType(superInterfaceType);
        }
        this.initializeInheritedTypeMap();
        this.getTypeDec().addInnerTypes();
    }

    public void buildSignatures() {
        if (this.builtSignatures) {
            this.getCompiler().internalError("already built signatures: " + this.getPrettyString());
            return;
        }
        this.builtSignatures = true;
        this.getCompiler().showMessage("  building signatures " + this.getPrettyString());
        if (this.getTypeDec().fromSource()) {
            this.checkForCircularities();
        }
        this.getWorld().runTypeDecPlanners(this.getTypeDec(), 1);
        this.getTypeDec().addDecs(this);
        this.getWorld().runTypeDecPlanners(this.getTypeDec(), 2);
        this.handleInheritedMembers();
    }

    public Collection getInnerTypes() {
        return this.innerTypes.getAllSemanticObjects();
    }

    public Type getOutermostLexicalType() {
        return this.getTypeDec().getOutermostLexicalType();
    }

    public Type getOutermostBytecodeType() {
        return this.getTypeDec().getOutermostBytecodeType();
    }

    public void setLazy() {
        this.isLazy = true;
    }

    public void checkForCircularities() {
        this.checkForCircularities(new LinkedList());
    }

    private boolean checkForCircularities(LinkedList list) {
        if (list.contains(this)) {
            StringBuffer message = new StringBuffer("cyclic inheritance, ");
            boolean foundThis = false;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                if (t == this) {
                    foundThis = true;
                }
                if (!foundThis) continue;
                message.append(t.getString());
                message.append(" -> ");
            }
            message.append(this.getString());
            this.getTypeDec().showError(message.toString());
            this.directSuperTypes.clear();
            return true;
        }
        list.add(this);
        if (this.getEnclosingType() != null && this.getEnclosingType().checkForCircularities(list)) {
            return true;
        }
        Iterator i = this.directSuperTypes.iterator();
        while (i.hasNext()) {
            NameType superType = (NameType)i.next();
            if (!superType.checkForCircularities(list)) continue;
            return true;
        }
        list.removeLast();
        return false;
    }

    public synchronized String getInternalName() {
        if (this.internalName == null) {
            this.internalName = this.getClassName().replace('.', '/');
        }
        return this.internalName;
    }

    public synchronized String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = "L" + this.getInternalName() + ";";
        }
        return this.descriptor;
    }

    final LiteralExpr foldAddOp(LiteralExpr rand1, LiteralExpr rand2) {
        return this.getAST().makeLiteral(rand1.getStringValue() + rand2.getStringValue());
    }

    final LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        String a = lit1.getStringValue();
        String b = lit2.getStringValue();
        if (op == "==") {
            return ast.makeLiteral(a.equals(b));
        }
        if (op == "!=") {
            return ast.makeLiteral(!a.equals(b));
        }
        throw new RuntimeException("bad op " + op);
    }

    final LiteralExpr foldCast(LiteralExpr lit) {
        return this.getAST().makeLiteral(lit.getStringValue());
    }

    public boolean isInner() {
        return this.getTypeDec().isInner();
    }

    public NameType getEnclosingInstanceType() {
        return (NameType)this.getDeclaringType();
    }

    public boolean isLocal() {
        TypeDec typeDec = this.getTypeDec();
        if (typeDec == null) {
            return false;
        }
        return typeDec.isLocal();
    }

    public CodeDec getEnclosingCodeDec() {
        return this.getTypeDec().getEnclosingCodeDec();
    }

    public boolean isPackageMember() {
        return this.getTypeDec().isPackageMember();
    }

    public NameType getEnclosingType() {
        return (NameType)this.getDeclaringType();
    }
}

