/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;

public class NewInnerInstanceExpr
extends NewInstanceExpr {
    protected String innerName;

    public ASTObject postScope(ScopeWalker walker) {
        super.postScope(walker);
        return this;
    }

    public void preScope(ScopeWalker walker) {
        if (this.getEnclosingInstanceExpr() == null) {
            super.preScope(walker);
            return;
        }
        this.setEnclosingInstanceExpr((Expr)walker.process(this.getEnclosingInstanceExpr()));
        Type myType = this.getEnclosingInstanceExpr().getType().getInnerType(this.getInnerName(), this, true);
        this.setTypeD(myType.makeTypeD());
        if (this.typeDec != null) {
            ((ClassDec)this.typeDec).setSuperClass(myType.makeTypeD());
        }
    }

    public String getInnerName() {
        return this.innerName;
    }

    public void setInnerName(String _innerName) {
        this.innerName = _innerName;
    }

    public NewInnerInstanceExpr(SourceLocation location, Expr _enclosingInstanceExpr, TypeD _typeD, Exprs _args, TypeDec _typeDec, Constructor _constructor, String _innerName) {
        super(location, _enclosingInstanceExpr, _typeD, _args, _typeDec, _constructor);
        this.setInnerName(_innerName);
    }

    protected NewInnerInstanceExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NewInnerInstanceExpr ret = new NewInnerInstanceExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.enclosingInstanceExpr != null) {
            ret.setEnclosingInstanceExpr((Expr)walker.process(this.enclosingInstanceExpr));
        }
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        if (this.args != null) {
            ret.setArgs((Exprs)walker.process(this.args));
        }
        if (this.typeDec != null) {
            ret.setTypeDec((TypeDec)walker.process(this.typeDec));
        }
        ret.constructor = this.constructor;
        ret.innerName = this.innerName;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "NewInnerInstanceExpr(constructor: " + this.constructor + ", " + "innerName: " + this.innerName + ")";
    }
}

