/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.NewExpr;
import org.aspectj.compiler.base.ast.NewInnerInstanceExpr;
import org.aspectj.compiler.base.ast.SOLink;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.AccessFixer;

public class NewInstanceExpr
extends NewExpr
implements SOLink {
    protected Expr enclosingInstanceExpr;
    protected Exprs args;
    protected TypeDec typeDec;
    protected Constructor constructor;

    public CodeDec getCodeDec() {
        return this.getConstructorDec();
    }

    public ConstructorDec getConstructorDec() {
        return this.getConstructor().getConstructorDec();
    }

    public void setConstructorDec(ConstructorDec md) {
        this.setConstructor((Constructor)md.getCorrespondingSemanticObject());
    }

    public SemanticObject getTarget() {
        return this.getConstructor();
    }

    public void setTarget(SemanticObject newTarget) {
        this.setConstructor((Constructor)newTarget);
    }

    public boolean isLegalStmt() {
        return true;
    }

    public void walkInnerInfo(InnerInfoPass w) {
        super.walkInnerInfo(w);
    }

    public void postInnerInfo(InnerInfoPass w) {
        if (this.getConstructor() == null) {
            return;
        }
        NameType target = (NameType)this.getConstructor().getDeclaringType();
        if (InnerInfoPass.isInner(target) && this.getEnclosingInstanceExpr() == null) {
            NameType enclosingTarget = target.getEnclosingType();
            if (!w.isAccessible(enclosingTarget)) {
                this.showError("no enclosing instance available");
            } else {
                this.setEnclosingInstanceExpr(this.getAST().makePrimary(enclosingTarget, w.currentType(), false));
            }
        }
    }

    public void checkSpec() {
        NameType ty;
        if (this.getEnclosingInstanceExpr() != null && !(ty = this.getTypeDec() == null || !(this instanceof NewInnerInstanceExpr) ? (NameType)this.getConstructorDec().getDeclaringType() : (NameType)this.getTypeD().getType()).isInner()) {
            this.showError("Type " + ty.getId() + " is not an inner class");
        }
        super.checkSpec();
    }

    public ASTObject fixAccessPost(AccessFixer fixer) {
        if (this.getConstructor() == null) {
            return this;
        }
        if (this.getTypeDec() != null || this.getConstructor().isAccessible(this, true)) {
            return this;
        }
        this.getCompiler().showMessage("  fixing privileged new: " + this.getConstructor().toShortString());
        this.getConstructor().getConstructorDec().makePublicAccessible();
        return this;
    }

    public void walkFlow(FlowCheckerPass w) {
        super.walkFlow(w);
        if (this.getConstructor().getThrows() != null) {
            TypeDs ts = this.getConstructor().getThrows();
            int i = 0;
            int len = ts.size();
            while (i < len) {
                w.setExns(w.getExns().add((NameType)ts.get(i).getType()));
                ++i;
            }
        }
    }

    public boolean hasLegalProtectedAccess(Type fromType) {
        return this.typeDec != null;
    }

    public ASTObject postMove(MovingWalker walker) {
        walker.moveLink(this);
        if (this.enclosingInstanceExpr != null && walker.getToType() != null && (this.getTypeDec() != null || this.getType().getTypeDec().isLocal())) {
            this.enclosingInstanceExpr = !walker.isStatic ? this.getAST().makeThis(walker.getToType()) : null;
        }
        if (this.getTypeDec() != null) {
            this.setType(null);
            this.getType();
        }
        return this;
    }

    public ASTObject postScope(ScopeWalker walker) {
        if (this.constructor != null) {
            return this;
        }
        Type myType = this.typeDec != null ? this.typeDec.getType() : this.typeD.getType();
        if (this.typeDec == null) {
            if (this.typeD.getType().isInterface()) {
                this.showError("can't instantiate interface " + myType.toShortString());
            } else {
                this.constructor = this.typeD.getType().getConstructor(this, this.args, true);
            }
        } else {
            Constructor superConstructor = this.typeD.getType().isInterface() ? this.getTypeManager().getObjectType().getConstructor(this, this.args, true) : this.typeD.getType().getConstructor(this.typeDec.getBody(), this.args, true);
            ConstructorDec dec = this.buildAnonDec(superConstructor);
            dec.setAllEnclosingTypes(this.typeDec.getType());
            this.typeDec.addConstructorDec(dec);
            this.typeDec.getBody().add(dec);
            this.typeDec.setSoleConstructorDec(dec);
            this.constructor = (Constructor)dec.getCorrespondingSemanticObject();
            if (this.getEnclosingInstanceExpr() != null) {
                this.getArgs().add(0, this.enclosingInstanceExpr);
                this.setEnclosingInstanceExpr(null);
            }
        }
        if (this.fromSource() && myType.isAspect()) {
            this.showError("can't explicitly instantiate an aspect");
        }
        if (myType.getTypeDec().isAbstract()) {
            this.showError("can't instantiate abstract type " + myType.toShortString());
        }
        this.type = this.discoverType();
        return this;
    }

    private ConstructorDec buildAnonDec(Constructor superConstructor) {
        AST ast = superConstructor.getAST();
        Formals oldFormals = superConstructor.getFormals();
        TypeDs oldThrows = superConstructor.getThrows();
        Formals newFormals = ast.makeFormals();
        Exprs newArgs = ast.makeExprs();
        TypeDs newThrows = oldThrows == null ? ast.makeTypeDs() : (TypeDs)oldThrows.copy();
        int len = oldFormals.size();
        int i = 0;
        while (i < len) {
            FormalDec newFormal = (FormalDec)oldFormals.get(i).copy();
            newFormal.getModifiers().setFinal(true);
            VarExpr newArg = ast.makeVar(newFormal);
            newFormals.add(newFormal);
            newArgs.add(newArg);
            ++i;
        }
        VarExpr enclosingExpr = null;
        ConstructorCallExpr cce = null;
        if (this.getEnclosingInstanceExpr() != null) {
            FormalDec newFormal = ast.makeFinalFormal(this.getEnclosingInstanceExpr().getType(), "super$enc$obj");
            newFormals.add(0, newFormal);
            enclosingExpr = ast.makeVar(newFormal);
            cce = new ConstructorCallExpr(ast.getSourceLocation(), enclosingExpr, true, newArgs, superConstructor);
        } else {
            cce = ast.makeSuperConstructorCall(newArgs, superConstructor);
        }
        return ast.makeConstructor(ast.makeModifiers(0), newFormals, newThrows, cce, ast.makeStmts());
    }

    public Type discoverType() {
        if (this.typeDec == null) {
            return this.typeD.getType();
        }
        return this.typeDec.getType();
    }

    public Type getCalledType() {
        return this.getType();
    }

    public void fixForIntroductions() {
        Expr extraArg = null;
        if (this.constructor != null) {
            extraArg = this.constructor.getExtraArgExpr();
        }
        if (extraArg != null) {
            this.args.add(extraArg);
        }
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        this.fixForIntroductions();
        return this;
    }

    public void unparse(CodeWriter writer) {
        if (this.getEnclosingInstanceExpr() == null) {
            writer.writeKeyword("new");
            writer.requiredSpace();
            writer.write(this.typeD);
            writer.parenExprs(this.args);
        } else {
            writer.write(this.enclosingInstanceExpr);
            writer.write('.');
            writer.writeKeyword("new");
            writer.requiredSpace();
            writer.write(this.getTypeD().getType().getId());
            writer.openParen('(');
            writer.write(this.args);
            writer.closeParen(')');
        }
        if (this.typeDec != null) {
            writer.openBlock();
            writer.write(this.typeDec.getBody());
            writer.closeBlock();
        }
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        ConstructorDec dec = this.getConstructorDec();
        if (!w.isAccessible(dec, this)) {
            dec.getModifiers().setPrivate(false);
        }
        return this;
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        cb.enterLocation(this.getSourceLocation());
        NameType declaringType = (NameType)this.constructor.getDeclaringType();
        cb.emitNEW(declaringType);
        if (needsValue) {
            cb.emitDUP();
        }
        if (this.enclosingInstanceExpr != null) {
            this.enclosingInstanceExpr.cgValue(cb, this.constructor.getEnclosingInstanceFormal().getType());
            if (!(this.getEnclosingInstanceExpr() instanceof ThisExpr)) {
                cb.emitDUP();
                cb.emitINVOKEVIRTUAL(this.getTypeManager().getObjectType(), "getClass", "()Ljava/lang/Class;", 0);
                cb.emitPOP();
            }
        }
        this.getArgs().cgValues(cb, this.constructor.getFormals());
        cb.emitINVOKESPECIAL(declaringType, "<init>", this.constructor.getDescriptor(), this.constructor.getStackDelta());
    }

    public void preLift(LocalClassPass.LiftWalker walker) {
        TypeDec anonTypeDec = this.getTypeDec();
        if (anonTypeDec == null) {
            return;
        }
        NameType nameType = anonTypeDec.getNameType();
        this.setTypeD(nameType.makeTypeD());
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
        walker.addArgs(this.getArgs(), this.getConstructor().getDeclaringType().getTypeDec());
    }

    public void remove(int index) {
        if (index == 3) {
            this.setTypeDec(null);
        } else {
            super.remove(index);
        }
    }

    public NewInstanceExpr(SourceLocation location, TypeD _typeD, Exprs _args, TypeDec _typeDec, Constructor _constructor) {
        this(location, null, _typeD, _args, _typeDec, _constructor);
    }

    public NewInstanceExpr(SourceLocation source, Constructor constructor, Exprs args) {
        this(source, null, constructor.getDeclaringType().makeTypeD(), args, null, constructor);
    }

    public NewInstanceExpr(SourceLocation source, TypeD typeD, Exprs args) {
        this(source, null, typeD, args, null, null);
    }

    public Expr getEnclosingInstanceExpr() {
        return this.enclosingInstanceExpr;
    }

    public void setEnclosingInstanceExpr(Expr _enclosingInstanceExpr) {
        if (_enclosingInstanceExpr != null) {
            _enclosingInstanceExpr.setParent(this);
        }
        this.enclosingInstanceExpr = _enclosingInstanceExpr;
    }

    public Exprs getArgs() {
        return this.args;
    }

    public void setArgs(Exprs _args) {
        if (_args != null) {
            _args.setParent(this);
        }
        this.args = _args;
    }

    public TypeDec getTypeDec() {
        return this.typeDec;
    }

    public void setTypeDec(TypeDec _typeDec) {
        if (_typeDec != null) {
            _typeDec.setParent(this);
        }
        this.typeDec = _typeDec;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor _constructor) {
        this.constructor = _constructor;
    }

    public NewInstanceExpr(SourceLocation location, Expr _enclosingInstanceExpr, TypeD _typeD, Exprs _args, TypeDec _typeDec, Constructor _constructor) {
        super(location, _typeD);
        this.setEnclosingInstanceExpr(_enclosingInstanceExpr);
        this.setArgs(_args);
        this.setTypeDec(_typeDec);
        this.setConstructor(_constructor);
    }

    protected NewInstanceExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NewInstanceExpr ret = new NewInstanceExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.enclosingInstanceExpr != null) {
            ret.setEnclosingInstanceExpr((Expr)walker.process(this.enclosingInstanceExpr));
        }
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        if (this.args != null) {
            ret.setArgs((Exprs)walker.process(this.args));
        }
        if (this.typeDec != null) {
            ret.setTypeDec((TypeDec)walker.process(this.typeDec));
        }
        ret.constructor = this.constructor;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.enclosingInstanceExpr;
            }
            case 1: {
                return this.typeD;
            }
            case 2: {
                return this.args;
            }
            case 3: {
                return this.typeDec;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "enclosingInstanceExpr";
            }
            case 1: {
                return "typeD";
            }
            case 2: {
                return "args";
            }
            case 3: {
                return "typeDec";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setEnclosingInstanceExpr((Expr)child);
                return;
            }
            case 1: {
                this.setTypeD((TypeD)child);
                return;
            }
            case 2: {
                this.setArgs((Exprs)child);
                return;
            }
            case 3: {
                this.setTypeDec((TypeDec)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 4;
    }

    public String getDefaultDisplayName() {
        return "NewInstanceExpr(constructor: " + this.constructor + ")";
    }
}

