/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class NumericTestOpExpr
extends BinopExpr {
    protected Type discoverType() {
        Expr rand1 = this.getRand1();
        Expr rand2 = this.getRand2();
        Type ty1 = rand1.getType();
        Type ty2 = rand2.getType();
        if (!(ty1 instanceof NumericType) || !(ty2 instanceof NumericType)) {
            this.showOperatorTypeError(this.op, ty1, ty2);
        }
        return this.getTypeManager().booleanType;
    }

    protected Type getLiftType() {
        Expr rand1 = this.getRand1();
        Expr rand2 = this.getRand2();
        Type ty1 = rand1.getType();
        Type ty2 = rand2.getType();
        if (ty1 instanceof NumericType && ty2 instanceof NumericType) {
            return this.getTypeManager().binaryNumericPromotion(ty1, ty2);
        }
        this.showOperatorTypeError(this.op, ty1, ty2);
        return this.getTypeManager().anyType;
    }

    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldNumericTestOp(this.getOp(), lit1, lit2);
    }

    protected void cgTest(CodeBuilder cb, Label t, Label f) {
        Type liftType = this.getLiftType();
        if (liftType.hasFastNumericTestOp()) {
            liftType.emitFastNumericTestOp(cb, this, t, f);
        } else {
            this.getRand1().cgValue(cb, liftType);
            this.getRand2().cgValue(cb, liftType);
            liftType.emitNumericCompare(cb, this.getOp(), t, f);
        }
    }

    protected void cgOp(CodeBuilder cb, Type ty) {
        throw new RuntimeException("Attempt to generate code for effect op " + this.getOp());
    }

    public NumericTestOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected NumericTestOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NumericTestOpExpr ret = new NumericTestOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "NumericTestOpExpr(op: " + this.op + ")";
    }
}

