/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.UnopExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class PlusOpExpr
extends UnopExpr {
    protected LiteralExpr halfFold(Type type, LiteralExpr lit) {
        return type.foldPlusOp(lit);
    }

    protected Type discoverType() {
        Expr rand1 = this.getRand1();
        Type ty1 = rand1.getType();
        if (ty1 instanceof NumericType) {
            return this.getTypeManager().unaryNumericPromotion(ty1);
        }
        this.showOperatorTypeError(ty1);
        return this.getTypeManager().anyType;
    }

    protected Type getLiftType() {
        return this.getType();
    }

    protected void cgValue(CodeBuilder cb) {
        Type liftType = this.getLiftType();
        this.getRand1().cgValue(cb, liftType);
    }

    public PlusOpExpr(SourceLocation location, String _op, Expr _rand1) {
        super(location, _op, _rand1);
    }

    protected PlusOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PlusOpExpr ret = new PlusOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.op = this.op;
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "PlusOpExpr(op: " + this.op + ")";
    }
}

