/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public abstract class PrimitiveType
extends Type {
    public abstract String getName();

    public PrimitiveType(JavaCompiler compiler) {
        super(compiler);
    }

    protected void showNotFoundError(String id, ASTObject fromWhere, String kind) {
        this.getCompiler().showError(fromWhere, "no " + kind + "s on primitive type: " + this.getName());
    }

    public Expr getClassExpr() {
        return this.getAST().makeStaticGet(this.getRefType(), "TYPE");
    }

    public Expr makeObject(Expr expr) {
        return this.getAST().makeNew(this.getRefType(), expr);
    }

    public Expr fromObject(Expr expr) {
        if (expr.getType().isPrimitive()) {
            return this.getAST().makeCast(this, expr);
        }
        return this.getAST().makeStaticCall(this.getTypeManager().getConversionsType(), this.getName() + "Value", expr);
    }

    public String toShortString() {
        return this.getName();
    }

    public boolean isEquivalent(Type other) {
        if (other.isAnyType()) {
            return true;
        }
        return this == other;
    }

    public final boolean isCoercableTo(Type other) {
        return this.isEquivalent(other) || this.isCoercableToOtherType(other);
    }

    protected boolean isCoercableToOtherType(Type other) {
        return false;
    }

    public final boolean isAssignableFrom(Type other) {
        return this.isEquivalent(other) || this.isAssignableFromOtherType(other);
    }

    protected boolean isAssignableFromOtherType(Type other) {
        return false;
    }

    public String toString() {
        return "PrimitiveType(" + this.getName() + ")";
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.getString());
    }

    final void emitNewarray(CodeBuilder cb) {
        cb.emitNEWARRAY(this.getTypeIndex());
    }

    final void emitInstanceof(CodeBuilder cb) {
        this.unsupportedEmit();
    }
}

