/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.EqualityTestOpExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public abstract class RefType
extends Type {
    public RefType(JavaCompiler compiler) {
        super(compiler);
    }

    final LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldBitNotOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldLogNotOp(LiteralExpr rand) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldBitwiseOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldShiftOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    final LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    LiteralExpr foldCast(LiteralExpr lit) {
        return this.unsupportedFold();
    }

    LiteralExpr foldAddOp(LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        return this.unsupportedFold();
    }

    void emitCast(CodeBuilder cb, Type castTo) {
        if (castTo.isAssignableFrom(this)) {
            return;
        }
        if (!(castTo instanceof RefType)) {
            System.err.println("can't emit cast for " + this + " to " + castTo);
            return;
        }
        cb.emitCHECKCAST((RefType)castTo);
    }

    void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "==") {
            cb.emitIF_ACMPEQ(t, f);
        } else if (op == "!=") {
            cb.emitIF_ACMPNE(t, f);
        }
    }

    void emitAload(CodeBuilder cb) {
        cb.emitAALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitAASTORE();
    }

    void emitNewarray(CodeBuilder cb) {
        cb.emitANEWARRAY(this);
    }

    void emitInstanceof(CodeBuilder cb) {
        cb.emitINSTANCEOF(this);
    }

    public void emitLoad(CodeBuilder cb, int loc) {
        cb.emitALOAD(loc);
    }

    public void emitStore(CodeBuilder cb, int loc) {
        cb.emitASTORE(loc);
    }

    public void emitReturn(CodeBuilder cb) {
        cb.emitARETURN();
    }

    String getInternalId() {
        return this.getId();
    }

    final void emitBitNot(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitLogNot(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitZero(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitOne(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitMinusOne(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitAdd(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitNeg(CodeBuilder cb) {
        this.unsupportedEmit();
    }

    final void emitNumericOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitBitwiseOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitShiftOp(CodeBuilder cb, String op) {
        this.unsupportedEmit();
    }

    final void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        throw new RuntimeException("Type " + this + " doesn't support op " + op);
    }

    final boolean hasFastEqualityTestOp() {
        return true;
    }

    final void emitFastEqualityTestOp(CodeBuilder cb, EqualityTestOpExpr e, Label t, Label f) {
        Expr rand1 = e.getRand1();
        Expr rand2 = e.getRand2();
        String op = e.getOp();
        if (rand1.isConstantZero()) {
            rand2.cgValue(cb, this);
            this.emitEqualityCompare0(cb, op, t, f);
        } else if (rand2.isConstantZero()) {
            rand1.cgValue(cb, this);
            this.emitEqualityCompare0(cb, op, t, f);
        } else {
            rand1.cgValue(cb, this);
            rand2.cgValue(cb, this);
            this.emitEqualityCompare(cb, op, t, f);
        }
    }

    private void emitEqualityCompare0(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "==") {
            cb.emitIFNULL(t, f);
        } else if (op == "!=") {
            cb.emitIFNONNULL(t, f);
        }
    }
}

