/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.SemanticMap;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.Type;

public class SemanticGroup
extends CompilerObject {
    protected String name;
    protected SemanticMap map;
    protected List members;
    private static final Mode inheritMode = new Mode(){

        SemanticObject handleConflict(Type inType, SemanticObject currentSO, SemanticObject newSO) {
            if (currentSO.checkOverride(inType, newSO)) {
                return currentSO;
            }
            return null;
        }
    };
    private static final Mode addMode = new Mode(){

        SemanticObject handleConflict(Type inType, SemanticObject currentSO, SemanticObject newSO) {
            newSO.showConflictError(currentSO, "defined in same type");
            return null;
        }
    };
    private static final Mode introduceMode = new Mode(){

        SemanticObject handleConflict(Type inType, SemanticObject currentSO, SemanticObject newSO) {
            if (currentSO.isAbstract() && !newSO.isAbstract()) {
                return currentSO;
            }
            if (newSO.isAbstract()) {
                return newSO;
            }
            if (newSO.dominates(currentSO)) {
                return currentSO;
            }
            if (currentSO.dominates(newSO)) {
                return newSO;
            }
            newSO.showConflictError(currentSO, "introduced member");
            return newSO;
        }
    };

    public SemanticGroup(SemanticMap map, SemanticObject o) {
        this(map, o.getName());
        this.members.add(o);
    }

    public SemanticGroup(SemanticMap map, String name) {
        this(map, name, new LinkedList());
    }

    private SemanticGroup(SemanticMap map, String name, List members) {
        super(map.getCompiler());
        this.map = map;
        this.name = name;
        this.members = members;
    }

    public Collection getMembers() {
        return this.members;
    }

    public String getName() {
        return this.name;
    }

    public SemanticGroup makeInheritedCopy(SemanticMap newMap) {
        SemanticGroup ret = new SemanticGroup(newMap, this.name);
        ret.inheritFrom(this);
        return ret;
    }

    public void inheritFrom(SemanticGroup otherGroup) {
        if (otherGroup == null || otherGroup == this) {
            return;
        }
        boolean skipObject = !this.map.getType().isInterface() && otherGroup.map.getType().isInterface();
        Iterator i = otherGroup.members.iterator();
        while (i.hasNext()) {
            SemanticObject so = (SemanticObject)i.next();
            if (skipObject && so.getDeclaringType().isObject() || !so.isInherited(this.map.getType())) continue;
            this.addSO(so, inheritMode);
        }
    }

    private SemanticObject addSO(SemanticObject newSO, Mode mode) {
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            SemanticObject currentSO = (SemanticObject)i.next();
            if (currentSO == newSO) {
                return newSO;
            }
            if (!currentSO.conflictsWith(newSO)) continue;
            SemanticObject removeSO = mode.handleConflict(this.map.getType(), currentSO, newSO);
            if (removeSO != null) {
                if (removeSO == currentSO) {
                    i.remove();
                    this.members.add(newSO);
                    return currentSO;
                }
                if (removeSO == newSO) {
                    return newSO;
                }
            }
            return null;
        }
        this.members.add(newSO);
        return null;
    }

    public void addDeclaredSO(SemanticObject newSO) {
        this.addSO(newSO, addMode);
    }

    public SemanticObject addIntroducedSO(SemanticObject newSO) {
        return this.addSO(newSO, introduceMode);
    }

    private boolean containsMissingTypes(Exprs exprs) {
        if (exprs == null) {
            return false;
        }
        int i = 0;
        while (i < exprs.size()) {
            if (exprs.get(i).getType().isMissing()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAccessible(SemanticObject o, ASTObject fromWhere) {
        return o.isAccessible(fromWhere) && this.map.getType().isAccessible(fromWhere);
    }

    public SemanticObject resolve(ASTObject fromWhere, Exprs params, boolean showError) {
        SemanticObject foundSemanticObject = null;
        ArrayList<SemanticObject> possibleSemanticObjects = null;
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            SemanticObject object = (SemanticObject)i.next();
            if (!object.isApplicable(params) || !this.isAccessible(object, fromWhere)) continue;
            if (foundSemanticObject == null) {
                foundSemanticObject = object;
                continue;
            }
            if (object.isMoreSpecificThan(foundSemanticObject)) {
                foundSemanticObject = object;
                continue;
            }
            if (foundSemanticObject.isMoreSpecificThan(object)) continue;
            if (this.containsMissingTypes(params)) {
                return this.map.getNotFoundSemanticObject();
            }
            if (possibleSemanticObjects == null) {
                possibleSemanticObjects = new ArrayList<SemanticObject>();
            }
            possibleSemanticObjects.add(foundSemanticObject);
            possibleSemanticObjects.add(object);
        }
        if (foundSemanticObject == null) {
            if (showError && !this.containsMissingTypes(params)) {
                this.showNotFoundError(fromWhere, params);
            }
            return this.map.getNotFoundSemanticObject();
        }
        if (possibleSemanticObjects != null) {
            Iterator i2 = possibleSemanticObjects.iterator();
            while (i2.hasNext()) {
                SemanticObject possibleSemanticObject = (SemanticObject)i2.next();
                if (foundSemanticObject.isMoreSpecificThan(possibleSemanticObject)) continue;
                if (showError && !this.containsMissingTypes(params)) {
                    this.getCompiler().showError(fromWhere, "two applicable and accessible " + this.map.getSemanticObjectTypeName() + "s are equally specific: " + possibleSemanticObject.toShortString() + " and " + foundSemanticObject.toShortString() + " in " + this.map.getType().getPrettyString());
                }
                return this.map.getNotFoundSemanticObject();
            }
        }
        return foundSemanticObject;
    }

    private void showNotFoundError(ASTObject fromWhere, Exprs params) {
        String kind = this.map.getSemanticObjectTypeName();
        String message = kind.equals("constructor") ? this.prettyIdString(this.map.getType().getPrettyString(), params) : this.prettyIdString(this.name, params);
        message = this.getExplanationString(message, fromWhere, params);
        this.getCompiler().showError(fromWhere, message);
    }

    private String prettyIdString(String id, Exprs args) {
        if (args == null) {
            return id;
        }
        StringBuffer message = new StringBuffer();
        if (id.equals("new")) {
            id = this.map.getType().getPrettyString();
        }
        message.append(id);
        if (args != null) {
            message.append("(");
            int i = 0;
            while (i < args.size()) {
                if (i > 0) {
                    message.append(", ");
                }
                message.append(args.get(i).getType().getString());
                ++i;
            }
            message.append(")");
        }
        return message.toString();
    }

    private String getExplanationString(String message, ASTObject fromWhere, Exprs parameters) {
        if (!this.map.getType().isAccessible(fromWhere)) {
            return "declaring type " + this.map.getType().getPrettyString() + " is not accessible here";
        }
        StringBuffer buf = new StringBuffer(message);
        String shortString = null;
        int notAccessibleMethods = 0;
        int notApplicableMethods = 0;
        buf.append(" not found in " + this.map.getType().getPrettyString());
        if (fromWhere == null) {
            return buf.toString();
        }
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            SemanticObject object = (SemanticObject)i.next();
            if (object.isApplicable(parameters)) {
                if (this.isAccessible(object, fromWhere)) continue;
                if (notAccessibleMethods == 0) {
                    shortString = object.toShortString() + " has " + object.getModifiers().getAccessValueString() + " access";
                }
                buf.append("\n  inaccessible " + this.map.getSemanticObjectTypeName() + " found: " + object.toShortString() + " from " + fromWhere.getLexicalType().toShortString());
                ++notAccessibleMethods;
                continue;
            }
            if (!object.isAlmostApplicable(parameters)) continue;
            if (notAccessibleMethods == 0 && notApplicableMethods == 0) {
                shortString = message + " doesn't match expected formals for " + object.toShortString();
            }
            buf.append("\n  not applicable " + this.map.getSemanticObjectTypeName() + " found: " + object.toShortString());
            ++notApplicableMethods;
        }
        if (shortString != null && (notAccessibleMethods == 1 || notApplicableMethods <= 1)) {
            return shortString;
        }
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.members.size() == 0;
    }

    public String toString() {
        return "group(" + this.name + ": " + this.members + ")";
    }

    private static abstract class Mode {
        private Mode() {
        }

        abstract SemanticObject handleConflict(Type var1, SemanticObject var2, SemanticObject var3);
    }
}

