/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.SemanticGroup;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.Type;

public class SemanticMap
extends CompilerObject {
    protected final Map map = new HashMap();
    protected final Type type;
    protected String kind;

    public SemanticMap(Type type, String kind) {
        super(type.getCompiler());
        this.type = type;
        this.kind = kind;
    }

    public SemanticObject get(String id, ASTObject fromWhere, Exprs params, boolean showError) {
        SemanticGroup semanticGroup = (SemanticGroup)this.map.get(id);
        if (semanticGroup == null) {
            if (showError) {
                this.showNotFoundError(id, fromWhere);
            }
            return this.getNotFoundSemanticObject();
        }
        return semanticGroup.resolve(fromWhere, params, showError);
    }

    public void addDeclared(SemanticObject objects) {
        String id = objects.getId();
        SemanticGroup semanticGroup = (SemanticGroup)this.map.get(id);
        if (semanticGroup == null) {
            this.map.put(id, this.makeSemanticGroup(objects));
        } else {
            semanticGroup.addDeclaredSO(objects);
        }
    }

    public SemanticObject addIntroduced(SemanticObject objects) {
        String id = objects.getId();
        SemanticGroup semanticGroup = (SemanticGroup)this.map.get(id);
        if (semanticGroup == null) {
            this.map.put(id, this.makeSemanticGroup(objects));
            return null;
        }
        return semanticGroup.addIntroducedSO(objects);
    }

    public boolean hasName(String id) {
        return this.map.get(id) != null;
    }

    public void addInherited(SemanticMap other) {
        Iterator i = other.map.values().iterator();
        while (i.hasNext()) {
            SemanticGroup superGroup = (SemanticGroup)i.next();
            String name = superGroup.getName();
            SemanticGroup myGroup = (SemanticGroup)this.map.get(name);
            if (myGroup == null) {
                myGroup = superGroup.makeInheritedCopy(this);
            } else {
                myGroup.inheritFrom(superGroup);
            }
            if (myGroup.isEmpty()) continue;
            this.map.put(name, myGroup);
        }
    }

    public Collection getAllSemanticObjects() {
        LinkedList ret = new LinkedList();
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            SemanticGroup group = (SemanticGroup)i.next();
            ret.addAll(group.members);
        }
        return ret;
    }

    public void ensureNoAbstracts() {
        Iterator i = this.getAllSemanticObjects().iterator();
        while (i.hasNext()) {
            SemanticObject object = (SemanticObject)i.next();
            if (!object.isAbstract()) continue;
            if (object.getDeclaringType() == this.getType()) {
                object.getCorrespondingDec().showError("abstract " + this.getSemanticObjectTypeName() + " not allowed in concrete type " + this.getType().toShortString());
                continue;
            }
            this.getType().getTypeDec().showError("concrete type " + this.getType().toShortString() + " must implement " + this.getSemanticObjectTypeName() + " " + object.toShortString());
        }
    }

    public SemanticObject findMatchingSemanticObject(SemanticObject matchSemanticObject) {
        Iterator i = this.getAllSemanticObjects().iterator();
        while (i.hasNext()) {
            SemanticObject object = (SemanticObject)i.next();
            if (!object.conflictsWith(matchSemanticObject)) continue;
            return object;
        }
        return null;
    }

    protected SemanticObject getNotFoundSemanticObject() {
        return null;
    }

    protected String getSemanticObjectTypeName() {
        return this.kind;
    }

    public Type getType() {
        return this.type;
    }

    protected SemanticGroup makeSemanticGroup(SemanticObject object) {
        return new SemanticGroup(this, object);
    }

    protected void showNotFoundError(String id, ASTObject fromWhere) {
        this.getCompiler().showError(fromWhere, "no " + this.getSemanticObjectTypeName() + " named " + id + " defined in " + this.type.toShortString());
    }
}

