/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntegralType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ShiftOpExpr
extends BinopExpr {
    protected Type discoverType() {
        Expr rand1 = this.getRand1();
        Expr rand2 = this.getRand2();
        Type ty1 = rand1.getType();
        Type ty2 = rand2.getType();
        if (ty1 instanceof IntegralType && ty2 instanceof IntegralType) {
            return this.getTypeManager().unaryNumericPromotion(ty1);
        }
        this.showOperatorTypeError(this.op, ty1, ty2);
        return this.getTypeManager().anyType;
    }

    protected Type getLiftType() {
        return this.getType();
    }

    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldShiftOp(this.getOp(), lit1, lit2);
    }

    protected void cgValue(CodeBuilder cb) {
        Type liftType = this.getLiftType();
        this.getRand1().cgValue(cb, liftType);
        this.getRand2().cgValue(cb, this.getTypeManager().intType);
        liftType.emitShiftOp(cb, this.getOp());
    }

    protected void cgOp(CodeBuilder cb, Type ty) {
        ty.emitShiftOp(cb, this.getOp());
    }

    public ShiftOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected ShiftOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ShiftOpExpr ret = new ShiftOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "ShiftOpExpr(op: " + this.op + ")";
    }
}

