/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public abstract class Stmt
extends ASTObject {
    private boolean completesNormallyFlag;

    public boolean mustBeLive() {
        return true;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public void requireBlockStmt() {
        this.showError("block statement required");
    }

    public void requireStmt() {
    }

    public void setCompletesNormally(boolean b) {
        this.completesNormallyFlag = b;
    }

    public boolean completesNormally() {
        return this.completesNormallyFlag;
    }

    final void cgTop(CodeBuilder cb) {
        this.registerLocation(cb);
        this.cgStmt(cb);
        if (cb.getStackSize() != 0) {
            this.showWarning("Sanity check: stack size is " + cb.getStackSize() + " after stmt " + this);
            cb.emitStackSize();
            cb.setStackSize(0);
        }
    }

    protected void registerLocation(CodeBuilder cb) {
        cb.enterLocation(this.getSourceLocation());
    }

    protected void cgStmt(CodeBuilder cb) {
        throw new RuntimeException("Invalid statement " + this);
    }

    public Stmt(SourceLocation location) {
        super(location);
    }

    public String getDefaultDisplayName() {
        return "Stmt()";
    }
}

