/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;

public class StringLiteralExpr
extends LiteralExpr {
    protected String stringValue;

    private static void quoteCharacter(char ch, StringBuffer buf) {
        switch (ch) {
            case '\b': {
                buf.append("\\b");
                return;
            }
            case '\t': {
                buf.append("\\t");
                return;
            }
            case '\n': {
                buf.append("\\n");
                return;
            }
            case '\f': {
                buf.append("\\f");
                return;
            }
            case '\r': {
                buf.append("\\r");
                return;
            }
            case '\"': {
                buf.append("\\\"");
                return;
            }
            case '\'': {
                buf.append("\\'");
                return;
            }
            case '\\': {
                buf.append("\\\\");
                return;
            }
        }
        buf.append(ch);
    }

    private static String quoteString(String value) {
        StringBuffer buf = new StringBuffer("\"");
        int i = 0;
        while (i < value.length()) {
            StringLiteralExpr.quoteCharacter(value.charAt(i), buf);
            ++i;
        }
        buf.append("\"");
        return buf.toString();
    }

    public StringLiteralExpr(SourceLocation source, String _stringValue) {
        this(source, source.getCompiler().getTypeManager().getStringType(), StringLiteralExpr.quoteString(_stringValue), _stringValue);
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitStringConstant(this.stringValue);
    }

    public void addConstant(FieldBuilder fb) {
        fb.setConstantValue(this.stringValue);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String _stringValue) {
        this.stringValue = _stringValue;
    }

    public StringLiteralExpr(SourceLocation location, Type _type, String _value, String _stringValue) {
        super(location, _type, _value);
        this.setStringValue(_stringValue);
    }

    protected StringLiteralExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        StringLiteralExpr ret = new StringLiteralExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.value = this.value;
        ret.stringValue = this.stringValue;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "StringLiteralExpr(type: " + this.type + ", " + "value: " + this.value + ", " + "stringValue: " + this.stringValue + ")";
    }
}

