/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;

public class SwitchClause
extends ASTObject {
    protected Expr label;
    protected Stmts stmts;

    public void unparse(CodeWriter writer) {
        if (this.label == null) {
            writer.writeln("default: ");
        } else {
            writer.writeKeyword("case");
            writer.requiredSpace();
            writer.write(this.label);
            writer.writeln(":");
        }
        if (this.stmts == null) {
            return;
        }
        writer.indent();
        writer.write(this.stmts);
        writer.dedent();
    }

    public Expr getLabel() {
        return this.label;
    }

    public void setLabel(Expr _label) {
        if (_label != null) {
            _label.setParent(this);
        }
        this.label = _label;
    }

    public Stmts getStmts() {
        return this.stmts;
    }

    public void setStmts(Stmts _stmts) {
        if (_stmts != null) {
            _stmts.setParent(this);
        }
        this.stmts = _stmts;
    }

    public SwitchClause(SourceLocation location, Expr _label, Stmts _stmts) {
        super(location);
        this.setLabel(_label);
        this.setStmts(_stmts);
    }

    protected SwitchClause(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        SwitchClause ret = new SwitchClause(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.label != null) {
            ret.setLabel((Expr)walker.process(this.label));
        }
        if (this.stmts != null) {
            ret.setStmts((Stmts)walker.process(this.stmts));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.label;
            }
            case 1: {
                return this.stmts;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "label";
            }
            case 1: {
                return "stmts";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setLabel((Expr)child);
                return;
            }
            case 1: {
                this.setStmts((Stmts)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "SwitchClause()";
    }
}

