/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.NullExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.WindingStmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class SynchronizedStmt
extends Stmt
implements WindingStmt {
    private int lockLoc;
    private int retValLoc;
    private int retPtrLoc;
    protected Expr expr;
    protected Stmt body;

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("synchronized");
        writer.requiredSpace();
        writer.parenExpr(this.expr);
        writer.write(this.body);
    }

    public void checkSpec() {
        if (!this.expr.getType().isReferenceType()) {
            this.expr.showError("reference type required");
        }
        if (this.expr instanceof NullExpr) {
            this.expr.showError("null not allowed");
        }
        if (!(this.body instanceof BlockStmt)) {
            this.body.showError("block {} required");
        }
    }

    public void walkFlow(FlowCheckerPass w) {
        w.process(this.getExpr());
        w.process(this.getBody());
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        if (this.getBody() instanceof EmptyStmt) {
            return this.getAST().makeStmt(this.getExpr()).setSource(this.getExpr());
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label startBody = cb.genAnchor();
        Label endBody = cb.genAnchor();
        Label startExn = cb.genAnchor();
        Label startFinally = cb.genAnchor();
        Label end = cb.genLabel();
        this.expr.cgValue(cb);
        cb.emitDUP();
        cb.emitASTORE(this.lockLoc);
        cb.emitMONITORENTER();
        cb.emitLabel(startBody);
        cb.enterWindingContext(this, startFinally);
        this.body.cgTop(cb);
        cb.leaveContext();
        cb.emitLabel(endBody);
        if (this.body.completesNormally()) {
            cb.emitALOAD(this.lockLoc);
            cb.emitMONITOREXIT();
            cb.emitJump(end);
        }
        cb.emitLabel(startExn);
        cb.pushStack(1);
        cb.emitASTORE(this.retValLoc);
        cb.emitJSR(startFinally);
        cb.emitALOAD(this.retValLoc);
        cb.emitATHROW();
        cb.emitLabel(startFinally);
        cb.pushStack(1);
        cb.emitASTORE(this.retPtrLoc);
        cb.emitALOAD(this.lockLoc);
        cb.emitMONITOREXIT();
        cb.emitRET(this.retPtrLoc);
        cb.emitLabel(end);
        cb.addHandler(startBody, endBody, startExn, null);
    }

    public int getRetValLoc() {
        return this.retValLoc;
    }

    public void walkFrameLoc(FrameLocPass walker) {
        boolean inTryFinally = walker.inTryFinally;
        walker.inTryFinally = true;
        int start = walker.getfs();
        this.lockLoc = walker.allocate(1);
        walker.process(this.getBody());
        walker.setfs(start + 1);
        this.retValLoc = walker.allocate(2);
        this.retPtrLoc = walker.allocate(1);
        walker.inTryFinally = inTryFinally;
        walker.setfs(start);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public SynchronizedStmt(SourceLocation location, Expr _expr, Stmt _body) {
        super(location);
        this.setExpr(_expr);
        this.setBody(_body);
    }

    protected SynchronizedStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        SynchronizedStmt ret = new SynchronizedStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
            case 1: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
            case 1: {
                this.setBody((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "SynchronizedStmt()";
    }
}

