/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.BangExpr;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.PostfixExpr;
import org.aspectj.compiler.base.ast.PrefixExpr;

public class SyntheticGetSet
extends CompilerObject {
    public BangExpr bangExpr;
    boolean isConcrete = false;
    FieldAccessExpr getExpr;
    AssignExpr setExpr;

    public SyntheticGetSet(JavaCompiler compiler, BangExpr bangExpr) {
        super(compiler);
        this.bangExpr = bangExpr;
    }

    public FieldAccessExpr makeGetExpr() {
        this.makeInnerExprs();
        return this.getExpr;
    }

    public AssignExpr makeSetExpr() {
        this.makeInnerExprs();
        return this.setExpr;
    }

    public BangExpr getBangExpr() {
        return this.bangExpr;
    }

    public void makeConcrete() {
        if (this.isConcrete) {
            return;
        }
        this.isConcrete = true;
        this.makeInnerExprs();
        this.bangExpr.replaceWith(this.finishSetExpr(this.setExpr));
    }

    Expr finishSetExpr(Expr setExpr) {
        if (this.bangExpr instanceof PostfixExpr) {
            if (this.bangExpr.isInExprStmt()) {
                return setExpr;
            }
            PostfixExpr postfixExpr = (PostfixExpr)this.bangExpr;
            String op = "-";
            if (postfixExpr.getOp().equals("--")) {
                op = "+";
            }
            AST ast = this.getAST();
            return ast.makeParen(ast.makeBinop(op, setExpr, ast.makeLiteral(1)));
        }
        return setExpr;
    }

    AssignExpr makeAssignExpr(BangExpr bangExpr) {
        if (bangExpr instanceof AssignExpr) {
            return (AssignExpr)bangExpr;
        }
        if (bangExpr instanceof PrefixExpr) {
            PrefixExpr prefixExpr = (PrefixExpr)bangExpr;
            String op = prefixExpr.getOp().substring(1);
            AST ast = this.getAST();
            return ast.makeSet(bangExpr.getLhs(), op, (Expr)ast.makeLiteral(1));
        }
        if (bangExpr instanceof PostfixExpr) {
            PostfixExpr postfixExpr = (PostfixExpr)bangExpr;
            String op = postfixExpr.getOp().substring(1);
            AST ast = this.getAST();
            return ast.makeSet(bangExpr.getLhs(), op, (Expr)ast.makeLiteral(1));
        }
        return null;
    }

    void makeInnerExprs() {
        if (this.getExpr != null) {
            return;
        }
        AST ast = this.getAST();
        AssignExpr assignExpr = this.makeAssignExpr(this.bangExpr);
        assignExpr.setParent(this.bangExpr.getParent());
        FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)this.bangExpr.getLhs();
        FieldDec fieldDec = fieldAccessExpr.getFieldDec();
        Expr baseExpr = fieldAccessExpr.getExpr();
        CodeBody body = this.bangExpr.getEnclosingCodeDec().getBody();
        String op = assignExpr.getOp();
        Expr newExpr = null;
        if (baseExpr != null) {
            newExpr = baseExpr.makeReference();
        }
        this.getExpr = ast.makeGet(newExpr, fieldDec);
        Expr newValue = ast.makeCast(fieldDec.getType(), ast.makeParen(ast.makeBinop(op, this.getExpr, assignExpr.getRhs())));
        Expr firstBaseExpr = fieldAccessExpr.getExpr();
        FieldAccessExpr lhs = ast.makeGet(firstBaseExpr, fieldDec);
        this.setExpr = ast.makeSet(lhs, newValue);
    }
}

