/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ThisExpr
extends Expr {
    public Type discoverType() {
        return this.getDeclaringType();
    }

    public ThisExpr(SourceLocation source, Type type) {
        super(source);
        this.setType(type);
    }

    public Expr makeReference() {
        return (Expr)this.copy();
    }

    public boolean canBeCopied() {
        return true;
    }

    public boolean isUltimatelyLiteral() {
        return false;
    }

    public ASTObject postMove(MovingWalker walker) {
        return walker.moveThisExpr(this, this.getType());
    }

    public void postInnerInfo(InnerInfoPass walker) {
        if (!walker.isAccessibleExactly(this.getType())) {
            if (!this.fromSource() && this.getParent().fromSource()) {
                this.getParent().showError("no instance available");
            } else {
                this.showError("no instance available");
            }
        }
    }

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("this");
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitALOAD(0);
    }

    protected void cgEffect(CodeBuilder cb) {
    }

    public ThisExpr(SourceLocation location) {
        super(location);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ThisExpr ret = new ThisExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        return ret;
    }

    public String getDefaultDisplayName() {
        return "ThisExpr()";
    }
}

