/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ThrowStmt
extends Stmt {
    protected Expr expr;

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("throw");
        writer.requiredSpace();
        writer.write(this.expr);
        writer.closeStmt();
    }

    public void checkSpec() {
        this.getExpr().assertType(this.getTypeManager().getThrowableType());
    }

    public void walkFlow(FlowCheckerPass w) {
        w.process(this.getExpr());
        w.doReturn();
        w.setLive(false);
        w.setExns(w.getExns().add((NameType)this.expr.getType()));
        w.setVars(FlowCheckerPass.getAllVars());
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        w.setLive(false);
    }

    protected void cgStmt(CodeBuilder cb) {
        this.expr.cgValue(cb);
        cb.emitATHROW();
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public ThrowStmt(SourceLocation location, Expr _expr) {
        super(location);
        this.setExpr(_expr);
    }

    protected ThrowStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ThrowStmt ret = new ThrowStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ThrowStmt()";
    }
}

