/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.MemberClassMunger;
import org.aspectj.compiler.base.NameHygienePass;
import org.aspectj.compiler.base.Options;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorBody;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.PackageSO;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.UnopExpr;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.cst.Scope;
import org.aspectj.compiler.base.cst.TypeScope;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;

public abstract class TypeDec
extends Dec {
    public Set memberTypeNames = null;
    protected NameType type = null;
    private Set extraWithinTypes = new HashSet();
    private TypeDec enclosingTypeDec = null;
    private int localTypesCounter = 0;
    private ConstructorDec soleConstructorDec;
    private boolean addToTypeGraphDone = false;
    private boolean addedInnersDone = false;
    private boolean addToTypeGraphInProgress = false;
    private boolean buildSignaturesDone = false;
    private boolean buildSignaturesInProgress = false;
    private boolean buildInnerSignaturesDone = false;
    public FieldDec joinPointFactoryDec = null;
    public List joinPoints0 = new ArrayList();
    public List joinPoints1 = new ArrayList();
    public List joinPoints2 = new ArrayList();
    private Set initializerExecutionJoinPoints = new HashSet();
    Field assertionsDisabledField = null;
    protected Modifiers modifiers;
    protected String id;
    protected TypeDs superInterfaces;
    protected Decs body;

    public void walkInnerInfo(InnerInfoPass w) {
        int context = w.inType(this instanceof InterfaceDec);
        w.enterType(this);
        super.walkInnerInfo(w);
        w.leaveType();
        w.restoreContext(context);
    }

    public void checkSpec() {
        super.checkSpec();
        this.checkConstructorLoops();
        this.checkParentNonFinal();
        if (this.isInner() || this.isLocal()) {
            this.checkNoStaticMembers();
        }
        if (!this.isAnonymous()) {
            TypeDec td = this.getEnclosingTypeDec();
            while (td != null) {
                if (td.getId().equals(this.getId())) {
                    this.showError("the name of this inner type conflicts with the name of an enclosing type: " + this.getId());
                }
                td = td.getEnclosingTypeDec();
            }
        }
        if (this.fromSource()) {
            PackageSO p;
            if (!this.getType().isAbstract()) {
                this.getNameType().ensureNoAbstractDecs();
            }
            if (this.isPackageMember() && (p = this.getTypeManager().findPackage(this.getPackageName())).containsSubPackage(this.getId())) {
                this.showError(this.getFullName() + " clashes with package of same name");
            }
        }
    }

    private void checkNoStaticMembers() {
        int i = 0;
        int N = this.body.size();
        while (i < N) {
            Dec dec = this.body.get(i);
            if (dec.isStatic()) {
                if (dec instanceof FieldDec) {
                    FieldDec fd = (FieldDec)dec;
                    if (!fd.isConstant()) {
                        dec.showError("all static fields in inners must be constant static finals");
                    }
                } else {
                    dec.showError("inner classes cannot have static declarations");
                }
            }
            ++i;
        }
    }

    private void checkParentNonFinal() {
        if (((NameType)this.getSuperClassType()).isFinal()) {
            this.showError("May not extend a final class");
        }
    }

    private void checkConstructorLoops() {
        int i = 0;
        int len = this.body.size();
        while (i < len) {
            Dec d = this.body.get(i);
            if (d instanceof ConstructorDec) {
                ConstructorDec cd = (ConstructorDec)d;
                HashSet<ConstructorDec> alreadySeen = new HashSet<ConstructorDec>();
                while (!cd.isSuper()) {
                    if (alreadySeen.contains(cd)) {
                        ((ConstructorBody)cd.getBody()).getConstructorCall().showError("a constructor may not directly or indirectly invoke itself");
                        break;
                    }
                    alreadySeen.add(cd);
                    cd = cd.getNextConstructorDec();
                }
            }
            ++i;
        }
    }

    public ASTObject walkMemberMunger(MemberClassMunger w) {
        w.enterType(this.getNameType());
        if (this.isInner()) {
            AST ast = this.getAST();
            NameType enclosingInstanceType = this.getEnclosingInstanceType();
            FieldDec enclosingInstanceField = ast.makeField(ast.makeModifiers(18), enclosingInstanceType, "this$" + enclosingInstanceType.getId());
            w.pushField(enclosingInstanceField);
            super.walkMemberMunger(w);
            w.popField();
            this.addFieldDec(enclosingInstanceField);
            this.getBody().add(0, enclosingInstanceField);
        } else {
            List fields = w.saveFields();
            super.walkMemberMunger(w);
            w.restoreFields(fields);
        }
        w.leaveType();
        return this;
    }

    public void walkFlow(FlowCheckerPass ww) {
        Decs body = this.getBody();
        int len = body.size();
        FlowCheckerPass.Set staticFinalFields = FlowCheckerPass.Set.getNone();
        FlowCheckerPass.Set dynamicFinalFields = FlowCheckerPass.Set.getNone();
        int i = 0;
        while (i < len) {
            Dec d = body.get(i);
            if (d instanceof FieldDec && d.isFinal()) {
                FieldDec dd = (FieldDec)d;
                if (d.isStatic()) {
                    staticFinalFields = staticFinalFields.add(dd);
                } else {
                    dynamicFinalFields = dynamicFinalFields.add(dd);
                }
            }
            ++i;
        }
        FlowCheckerPass w = new FlowCheckerPass(this.getCompiler(), this);
        int i2 = 0;
        while (i2 < len) {
            Dec d = body.get(i2);
            if (d.isStatic()) {
                if (d instanceof FieldDec && d.isFinal()) {
                    FieldDec fd = (FieldDec)d;
                    if (fd.getInitializer() != null) {
                        w.setVars(w.getVars().addAssigned(fd));
                    } else {
                        w.setVars(w.getVars().addUnassigned(fd));
                    }
                } else if (d instanceof InitializerDec) {
                    w.process(d);
                }
            }
            ++i2;
        }
        FlowCheckerPass.Set staticAssigned = w.getVars().getDa();
        FlowCheckerPass.Set x = staticFinalFields;
        while (!x.isEmpty()) {
            if (!staticAssigned.contains(x.first())) {
                w.showVarError(this, x.first(), "Field " + x.first().getId() + " might not be initialized");
            }
            x = x.rest();
        }
        staticAssigned = ww.getVars().getDa().union(staticFinalFields);
        w = new FlowCheckerPass(this.getCompiler(), staticAssigned, this);
        int i3 = 0;
        while (i3 < len) {
            Dec d = body.get(i3);
            if (!d.isStatic()) {
                if (d instanceof FieldDec && d.isFinal()) {
                    FieldDec fd = (FieldDec)d;
                    if (fd.getInitializer() != null) {
                        w.setVars(w.getVars().addAssigned(fd));
                    } else {
                        w.setVars(w.getVars().addUnassigned(fd));
                    }
                } else if (d instanceof InitializerDec) {
                    w.process(d);
                }
            }
            ++i3;
        }
        FlowCheckerPass.Vars preConstructorVars = w.getVars();
        FlowCheckerPass.Set dynamicAssigned = staticAssigned.union(dynamicFinalFields);
        TypeDs initializerThrows = w.getCheckedExns();
        int i4 = 0;
        while (i4 < len) {
            Dec d = body.get(i4);
            if (d instanceof ConstructorDec) {
                ConstructorDec cd = (ConstructorDec)d;
                if (this.isAnonymous()) {
                    cd.setThrows(initializerThrows);
                }
                if (cd.isSuper()) {
                    w = new FlowCheckerPass(this.getCompiler(), preConstructorVars, this);
                    w.process(d);
                    FlowCheckerPass.Set currentAssigned = w.getVars().getDa();
                    FlowCheckerPass.Set x2 = dynamicFinalFields;
                    while (!x2.isEmpty()) {
                        if (!currentAssigned.contains(x2.first())) {
                            w.showVarError(this, x2.first(), "Field " + x2.first().getId() + " might not be initialized");
                        }
                        x2 = x2.rest();
                    }
                } else {
                    w = new FlowCheckerPass(this.getCompiler(), dynamicAssigned, this);
                    w.process(d);
                }
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < len) {
            Dec d = body.get(i5);
            if (!(d instanceof FieldDec || d instanceof InitializerDec || d instanceof ConstructorDec)) {
                w = new FlowCheckerPass(this.getCompiler(), dynamicAssigned, this);
                w.process(d);
            }
            ++i5;
        }
    }

    public int getDepth() {
        if (this.getEnclosingTypeDec() == null) {
            return 0;
        }
        return 1 + this.getEnclosingTypeDec().getDepth();
    }

    public void preMove(MovingWalker walker) {
        walker.pushLexicalType(this.getType());
    }

    public void preCopy(CopyWalker walker, ASTObject oldObject) {
        walker.pushLexicalType(this.getType());
    }

    public ASTObject postCopy(CopyWalker walker, ASTObject oldObject) {
        TypeDec oldTypeDec = (TypeDec)oldObject;
        if (walker.hasToType()) {
            this.setEnclosingTypeDec(walker.getToType().getTypeDec());
        } else {
            this.setEnclosingTypeDec(oldTypeDec.getEnclosingTypeDec());
        }
        return super.postCopy(walker, oldObject);
    }

    public ASTObject postMove(MovingWalker walker) {
        int i = 0;
        while (i < this.body.size()) {
            this.body.get(i).setDeclaringType(this.getType());
            ++i;
        }
        walker.popLexicalType();
        return super.postMove(walker);
    }

    public Type getType() {
        return this.getNameType();
    }

    public void setType(NameType type) {
        this.type = type;
    }

    public NameType getNameType() {
        if (this.type == null) {
            this.type = new NameType(this);
        }
        return this.type;
    }

    public TypeDec getBytecodeTypeDec() {
        return this;
    }

    public SemanticObject makeCorrespondingSemanticObject() {
        return this.getType();
    }

    public Set getExtraWithinTypes() {
        return this.extraWithinTypes;
    }

    public void addExtraWithinType(Type type) {
        this.extraWithinTypes.add(type);
    }

    public Type getSuperClassType() {
        return this.getTypeManager().getObjectType();
    }

    public Collection getSuperInterfaceTypes() {
        return this.makeInterfaceTypesFromTypeDs(this.superInterfaces);
    }

    public void addSuperInterfaceType(Type newSuperType) {
        TypeDs list = this.getSuperInterfaces();
        if (list == null) {
            list = this.getAST().makeTypeDs();
            this.setSuperInterfaces(list);
        }
        list.add(newSuperType.makeTypeD());
    }

    public void setEnclosingTypeDec(TypeDec dec) {
        this.enclosingTypeDec = dec;
    }

    public TypeDec getEnclosingTypeDec() {
        return this.enclosingTypeDec;
    }

    public TypeDec getDeclaringTypeDec() {
        return this.getEnclosingTypeDec();
    }

    public TypeDec getOutermostTypeDec() {
        TypeDec immediateParent = this.getEnclosingTypeDec();
        if (immediateParent == null) {
            return this;
        }
        return immediateParent.getOutermostTypeDec();
    }

    public Type getOutermostType() {
        TypeDec immediateParent = this.getEnclosingTypeDec();
        if (immediateParent == null) {
            return this.getType();
        }
        return immediateParent.getOutermostType();
    }

    public boolean isInnerType() {
        return this.getDeclaringTypeDec() != null;
    }

    public boolean isInnerTypeOf(TypeDec parentType) {
        TypeDec immediateParent = this.getDeclaringTypeDec();
        if (immediateParent == null) {
            return false;
        }
        if (immediateParent == parentType) {
            return true;
        }
        return immediateParent.isInnerTypeOf(parentType);
    }

    public boolean hasGlobalName() {
        if (this.isLocal()) {
            return false;
        }
        TypeDec immediateParent = this.getDeclaringTypeDec();
        if (immediateParent == null) {
            return true;
        }
        return immediateParent.hasGlobalName();
    }

    public boolean isLocallyDefined() {
        return this.isLocal();
    }

    public abstract boolean isAnonymous();

    public boolean canOverride(Dec otherDec) {
        return true;
    }

    public boolean isRoot() {
        return this == this.getTypeManager().getObjectType().getTypeDec();
    }

    public boolean isConcrete() {
        return !(this instanceof InterfaceDec);
    }

    public int allocateLocalTypeIndex() {
        return ++this.localTypesCounter;
    }

    public String getExtendedId() {
        if (this.getEnclosingTypeDec() != null) {
            return this.getEnclosingTypeDec().getExtendedId() + '$' + this.id;
        }
        return this.id;
    }

    public String getSourceExtendedId() {
        if (this.getEnclosingTypeDec() != null) {
            return this.getEnclosingTypeDec().getSourceExtendedId() + '.' + this.id;
        }
        return this.id;
    }

    protected Collection makeInterfaceTypesFromTypeDs(TypeDs typeDs) {
        if (typeDs == null || typeDs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Type> ret = new ArrayList<Type>(typeDs.size());
        int i = 0;
        while (i < typeDs.size()) {
            Type type = typeDs.get(i).getType();
            if (!type.isInterface()) {
                typeDs.get(i).showError("interface required, not " + type.toShortString());
            } else if (ret.contains(type)) {
                typeDs.get(i).showError("repeated parent interface " + type.toShortString());
            } else {
                ret.add(type);
            }
            ++i;
        }
        return ret;
    }

    protected void addPointcutDec(PointcutDec pointcutDec) {
        this.type.addPointcut(pointcutDec);
    }

    protected void addFieldDec(FieldDec fieldDec) {
        this.type.addField(fieldDec);
    }

    protected void addMethodDec(MethodDec methodDec) {
        if (this.getModifiers().isStrict() && !methodDec.getModifiers().isAbstract()) {
            methodDec.getModifiers().setStrict(true);
        }
        this.type.addMethod(methodDec);
    }

    protected void addConstructorDec(ConstructorDec constructorDec) {
        if (this.getModifiers().isStrict()) {
            constructorDec.getModifiers().setStrict(true);
        }
        this.type.addConstructor(constructorDec);
    }

    protected void addTypeDec(TypeDec typeDec) {
        if (this.getModifiers().isStrict()) {
            typeDec.getModifiers().setStrict(true);
        }
        typeDec.enclosingTypeDec = this;
        typeDec.setAllEnclosingTypes(this.getType());
        ((NameType)this.getType()).addInnerType(typeDec);
    }

    public void addMemberTypeDec(TypeDec memberDec) {
        this.addTypeDec(memberDec);
        this.getBody().add(memberDec);
    }

    public void addMemberMethodDec(MethodDec memberDec) {
        this.addMethodDec(memberDec);
        this.getBody().add(memberDec);
    }

    public void addIntroducedDec(Dec dec) {
        this.getBody().add(dec);
        SemanticObject oldSO = null;
        if (dec instanceof MethodDec) {
            oldSO = this.type.methods.addIntroduced(dec.getCorrespondingSemanticObject());
        } else if (dec instanceof FieldDec) {
            oldSO = this.type.fields.addIntroduced(dec.getCorrespondingSemanticObject());
        } else if (dec instanceof ConstructorDec) {
            oldSO = this.type.constructors.addIntroduced(dec.getCorrespondingSemanticObject());
        }
        if (oldSO != null) {
            this.getBody().remove(oldSO.getCorrespondingDec());
        }
    }

    protected void addInitializerDec(InitializerDec dec) {
    }

    protected void addDec(Dec dec) {
        if (!(dec.isLanguageVisible() || dec.getId().equals("aspectOf") || dec.getId().equals("hasAspect"))) {
            return;
        }
        if (dec instanceof TypeDec) {
            this.addTypeDec((TypeDec)dec);
        } else if (dec instanceof MethodDec) {
            this.addMethodDec((MethodDec)dec);
        } else if (dec instanceof FieldDec) {
            this.addFieldDec((FieldDec)dec);
        } else if (dec instanceof ConstructorDec) {
            this.addConstructorDec((ConstructorDec)dec);
        } else if (dec instanceof PointcutDec) {
            this.addPointcutDec((PointcutDec)dec);
        } else if (dec instanceof InitializerDec) {
            this.addInitializerDec((InitializerDec)dec);
        } else if (dec instanceof VarDec) {
            this.showWarning("shouldn't be found in a class");
        } else {
            dec.showWarning("shouldn't be found in " + this.toShortString());
        }
    }

    public final String getPackageName() {
        if (this.getEnclosingTypeDec() != null) {
            return this.getEnclosingTypeDec().getPackageName();
        }
        return this.getCompilationUnit().getPackageName();
    }

    public void setSoleConstructorDec(ConstructorDec d) {
        this.soleConstructorDec = d;
    }

    public ConstructorDec getSoleConstructorDec() {
        return this.soleConstructorDec;
    }

    public void addInnerTypes() {
        Decs decs;
        if (this.memberTypeNames != null) {
            Iterator i = this.memberTypeNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (name == null || name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
                    this.getCompiler().showMessage("ignoring invalid inner class attribute: " + this.getExtendedId() + '$' + name);
                    continue;
                }
                Type innerType = this.getTypeManager().findType(this.getPackageName(), this.getExtendedId() + '$' + name);
                if (innerType == null) {
                    this.getCompiler().showMessage("ignoring invalid inner class attribute: " + this.getExtendedId() + '$' + name);
                    continue;
                }
                this.addTypeDec(innerType.getTypeDec());
            }
        }
        if ((decs = this.getBody()) == null) {
            if (this.getOptions().torture) {
                this.showWarning("no body for " + this);
            }
            return;
        }
        int N = decs.size();
        int i = 0;
        while (i < N) {
            if (decs.get(i) instanceof TypeDec) {
                this.addDec(decs.get(i));
            }
            ++i;
        }
    }

    public void addDecs(NameType toThis) {
        Decs decs = this.getBody();
        if (decs == null) {
            if (this.getOptions().torture) {
                this.showWarning("no body for " + this);
            }
            return;
        }
        int N = decs.size();
        int i = 0;
        while (i < N) {
            if (!(decs.get(i) instanceof TypeDec)) {
                this.addDec(decs.get(i));
            }
            ++i;
        }
    }

    private ConstructorDec makeDefaultConstructor() {
        AST ast = this.getAST();
        ConstructorCallExpr superCall = null;
        if (!this.isRoot()) {
            Constructor superConstructor = this.getSuperClassType().getConstructor(this.getBody(), ast.makeExprs(), true);
            superCall = ast.makeSuperConstructorCall(superConstructor);
        }
        ConstructorDec ret = ast.makeConstructor(ast.makeModifiers(this.getModifiers().getAccessValue()), ast.makeFormals(), ast.makeTypeDs(), superCall, ast.makeStmts());
        ret.setLanguageVisible();
        ret.setSourceLocation(this.getSourceLocation());
        return ret;
    }

    void addDefaultConstructor() {
        if (this.body == null || this.getType().isObject()) {
            return;
        }
        if (this.isAnonymous()) {
            return;
        }
        ConstructorDec ret = this.makeDefaultConstructor();
        this.addConstructorDec(ret);
        this.body.add(ret);
    }

    public void postIntroductionFinish() {
        if (((NameType)this.getType()).getConstructors().size() == 0) {
            if (!this.isAnonymous()) {
                this.addDefaultConstructor();
            }
        } else if (this.isAnonymous()) {
            this.showError("Anonymous classes cannot define constructors");
        }
    }

    public void addToBody(Dec dec) {
        this.getBody().add(dec);
    }

    public void addToBodyAndType(Dec dec) {
        this.addToBody(dec);
        this.addDec(dec);
    }

    public String getPrettyString() {
        return this.getType().getPrettyString();
    }

    public String toString() {
        return this.getType().getString();
    }

    public String toShortString() {
        return this.getType().getString();
    }

    public void fixAST(ASTFixerPass fixer) {
        TypeDec saveTypeDec = fixer.getInTypeDec();
        fixer.setInTypeDec(this);
        this.walk(fixer);
        fixer.setInTypeDec(saveTypeDec);
        if (this.getOptions().jvmTorture) {
            return;
        }
        NameType myType = this.getNameType();
        if (myType.isInterface()) {
            return;
        }
        if (!myType.isAbstract()) {
            return;
        }
        Iterator i = myType.getMethods().iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.getDeclaringType().isInterface() || m.getMethodDec().getBody() != null || m.getMethodDec().isIntroduced()) continue;
            this.getBody().add((MethodDec)m.getMethodDec().copy());
        }
    }

    protected void walkExtendsAndImplements(ScopeWalker walker) {
        if (this.superInterfaces != null) {
            walker.process(this.superInterfaces);
        }
    }

    protected void walkBody(ScopeWalker walker) {
        walker.process(this.body);
    }

    protected Scope getEnclosingScope(boolean justTypeGraph) {
        TypeDec td;
        if (this.isLocal()) {
            this.getCompiler().internalError(this, "trying to get simple scope for a local type");
        }
        if ((td = this.getEnclosingTypeDec()) == null) {
            return this.getCompilationUnit().getScope();
        }
        TypeScope ret = new TypeScope(this.getCompiler(), td.getEnclosingScope(justTypeGraph), td.getType());
        if (justTypeGraph) {
            td.addToTypeGraph();
        } else {
            td.buildSignatures();
        }
        return ret;
    }

    public void addToTypeGraph() {
        if (!this.fromSource()) {
            this.getNameType().addToTypeGraph();
        } else {
            this.addThisToTypeGraph(new ScopeWalker(this.getCompiler(), this.getEnclosingScope(true)));
        }
    }

    public void buildSignatures() {
        if (!this.fromSource()) {
            this.getNameType().buildSignatures();
        } else {
            this.buildThisSignatures(new ScopeWalker(this.getCompiler(), this.getEnclosingScope(false)));
        }
    }

    private boolean isUnsupportedType() {
        String p = this.getPackageName();
        return p != null && p.equals("java.lang") && (this.getId().equals("Object") || this.getId().equals("String"));
    }

    public void addToTypeGraph(ScopeWalker walker) {
        if (this.isUnsupportedType()) {
            this.showError("can not compile " + this.getPrettyString() + " (compiler limitation)");
            return;
        }
        this.addThisToTypeGraph(walker);
        this.addInnersToTypeGraph(walker);
    }

    private void addThisToTypeGraph(ScopeWalker walker) {
        if (this.addToTypeGraphDone) {
            return;
        }
        if (this.addToTypeGraphInProgress) {
            StringBuffer message = new StringBuffer("cyclic inheritance, ");
            this.getWorld().getBuildingTypeGraph();
            boolean foundThis = false;
            LinkedList l = this.getWorld().getBuildingTypeGraph();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                TypeDec td = (TypeDec)i.next();
                if (td == this) {
                    foundThis = true;
                }
                if (!foundThis) continue;
                message.append(td.toShortString());
                message.append(" -> ");
            }
            message.append(this.toShortString());
            this.showError(message.toString());
            return;
        }
        this.getWorld().pushBuildingTypeGraph(this);
        this.addToTypeGraphInProgress = true;
        walker.addTypeDec(this);
        this.walkExtendsAndImplements(walker);
        this.getNameType().addToTypeGraph();
        this.getWorld().popBuildingTypeGraph();
        this.addToTypeGraphDone = true;
    }

    private void addInnersToTypeGraph(ScopeWalker walker) {
        if (this.addedInnersDone) {
            return;
        }
        this.addedInnersDone = true;
        walker.pushScope(new TypeScope(this.getCompiler(), null, this.getType()));
        Decs decs = this.getBody();
        int i = 0;
        int N = decs.size();
        while (i < N) {
            Dec dec = decs.get(i);
            if (dec instanceof TypeDec) {
                ((TypeDec)dec).addToTypeGraph(walker);
            }
            ++i;
        }
        boolean saveWalkBodies = walker.walkBodies();
        walker.setWalkBodies(false);
        this.walkBody(walker);
        walker.setWalkBodies(saveWalkBodies);
        walker.popScope();
    }

    public void buildSignatures(ScopeWalker walker) {
        this.buildThisSignatures(walker);
        this.buildInnerSignatures(walker);
    }

    private void buildThisSignatures(ScopeWalker walker) {
        if (this.buildSignaturesDone) {
            return;
        }
        if (this.buildSignaturesInProgress) {
            this.showError("circularity detected, already building signatures");
            return;
        }
        this.buildSignaturesInProgress = true;
        this.addToTypeGraph(walker);
        this.getNameType().buildSignatures();
        this.postIntroductionFinish();
        this.buildSignaturesDone = true;
    }

    private void buildInnerSignatures(ScopeWalker walker) {
        if (this.buildInnerSignaturesDone) {
            return;
        }
        this.buildInnerSignaturesDone = true;
        walker.pushScope(new TypeScope(this.getCompiler(), null, this.getType()));
        Decs decs = this.getBody();
        int i = 0;
        int N = decs.size();
        while (i < N) {
            Dec dec = decs.get(i);
            if (dec instanceof TypeDec) {
                ((TypeDec)dec).buildSignatures(walker);
            }
            ++i;
        }
        walker.popScope();
    }

    public void walkScope(ScopeWalker walker) {
        if (!(walker instanceof NameHygienePass)) {
            if (walker.walkBodies()) {
                this.buildSignatures(walker);
            } else {
                this.addToTypeGraph(walker);
            }
        } else {
            this.walkExtendsAndImplements(walker);
        }
        walker.pushScope(new TypeScope(this.getCompiler(), null, this.getType()));
        this.walkBody(walker);
        walker.popScope();
    }

    public String getFullName() {
        String fullName = null;
        if (fullName == null) {
            if (this.getEnclosingTypeDec() != null) {
                fullName = this.getEnclosingTypeDec().getFullName() + '$' + this.getId();
            } else {
                String packageName = this.getPackageName();
                String id = this.getId();
                fullName = packageName == null ? id : packageName + '.' + id;
            }
        }
        return fullName;
    }

    public void setInnerDiscoveries(boolean a, boolean b, boolean c) {
        this.setIsInner(b);
    }

    public void setIsInner(boolean b) {
        if (b) {
            throw new RuntimeException("TypeDec " + this + " should never be inner");
        }
    }

    public Type getOutermostBytecodeType() {
        if (this.isPackageMember()) {
            return this.getType();
        }
        return super.getOutermostBytecodeType();
    }

    public Type getOutermostLexicalType() {
        if (this.isPackageMember()) {
            return this.getType();
        }
        return super.getOutermostLexicalType();
    }

    public boolean isInner() {
        return false;
    }

    public void setLocal() {
    }

    public boolean isLocal() {
        ASTObject parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return (parent = parent.getParent()) != null && !(parent instanceof TypeDec) && !(parent instanceof CompilationUnit);
    }

    public boolean isPackageMember() {
        ASTObject parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return (parent = parent.getParent()) != null && parent instanceof CompilationUnit;
    }

    public NameType getEnclosingInstanceType() {
        return (NameType)this.getDeclaringType();
    }

    public TypeDec getEnclosingInstanceTypeDec() {
        return this.getEnclosingInstanceType().getTypeDec();
    }

    public Set getInitializerExecutionJoinPoints() {
        return this.initializerExecutionJoinPoints;
    }

    public void walkForwardReference(ForwardReferenceChecker w) {
        this.walk(w.createTypeChecker(this));
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        if (this.isLocal()) {
            walker.enterTypeDec(this);
            this.setId(walker.makeNewId(this));
        }
        walker.inType();
        this.walk(walker);
        if (this.isLocal()) {
            walker.leaveTypeDec();
        }
    }

    public void preLift(LocalClassPass.LiftWalker walker) {
        walker.pushPendingDecs();
    }

    public ASTObject postLift(LocalClassPass.LiftWalker walker) {
        this.initializersToConstructors();
        walker.popPendingDecsInto(this);
        if (this.isLocal()) {
            walker.addToPendingDecs(this);
            return null;
        }
        return this;
    }

    public void collectInitializers(boolean collectSynthetics) {
        this.collectInitializers(true, collectSynthetics);
        this.collectInitializers(false, collectSynthetics);
    }

    public Field getAssertionsDisabledField() {
        if (this.assertionsDisabledField != null) {
            return this.assertionsDisabledField;
        }
        AST ast = this.getAST();
        Modifiers mods = ast.makeModifiers(24);
        PrimitiveType type = this.getTypeManager().booleanType;
        String id = "ajc$assertionsDisabled";
        UnopExpr init = ast.makeUnop("!", ast.makeCall(ast.makeLiteral(this.getOutermostType()), "desiredAssertionStatus"));
        FieldDec adf = ast.makeField(mods, type, id, init);
        adf.setDeclaringType(this.getType());
        this.assertionsDisabledField = adf.getField();
        return this.assertionsDisabledField;
    }

    public void addAssertionField() {
        if (this.assertionsDisabledField != null) {
            this.getBody().add(0, this.assertionsDisabledField.getFieldDec());
        }
    }

    public void collectInitializers(boolean isStatic, boolean collectSynthetics) {
        if (isStatic && (!collectSynthetics || this.getCompiler().willGenerateSourceCode()) && this instanceof InterfaceDec) {
            return;
        }
        AST ast = this.getAST();
        Stmts stmts = ast.makeStmts();
        InitializerDec ret = null;
        boolean singleInitializer = true;
        ListIterator i = this.body.iterator();
        while (i.hasNext()) {
            Dec memDec = (Dec)i.next();
            if (isStatic != memDec.isStatic()) continue;
            if (memDec instanceof InitializerDec) {
                InitializerDec iDec = (InitializerDec)memDec;
                stmts.addAll(iDec.getBody().getStmts());
                if (ret == null) {
                    ret = iDec;
                } else {
                    singleInitializer = false;
                }
                i.remove();
                continue;
            }
            if (!(memDec instanceof FieldDec)) continue;
            FieldDec fDec = (FieldDec)memDec;
            if (!collectSynthetics && !fDec.isLanguageVisible()) continue;
            fDec.getAssignExpr();
        }
        if (ret != null) {
            // empty if block
        }
        if (stmts.size() == 1 && stmts.get(0) instanceof BlockStmt) {
            stmts = ((BlockStmt)stmts.get(0)).getStmts();
        }
        ret = isStatic ? ast.makeStaticInitializer(stmts) : ast.makeInitializer(stmts);
        ret.setSourceLocation(this.getSourceLocation());
        this.body.add(ret);
    }

    public InitializerDec getSingleInitializerDec(boolean isStatic) {
        ListIterator i = this.body.iterator();
        while (i.hasNext()) {
            Dec memDec = (Dec)i.next();
            if (!(memDec instanceof InitializerDec) || isStatic != memDec.isStatic()) continue;
            return (InitializerDec)memDec;
        }
        this.showError("no initializer for: " + this);
        return null;
    }

    private void initializersToConstructors() {
        AST ast = this.getAST();
        Stmts stmts = ast.makeStmts();
        ListIterator i = this.getBody().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof InitializerDec)) continue;
            InitializerDec iDec = (InitializerDec)o;
            if (iDec.isStatic()) {
                if (iDec.getBody().getStmts().size != 0) continue;
                i.remove();
                continue;
            }
            i.remove();
            CodeBody iStmt = iDec.getBody();
            if (iStmt instanceof BlockStmt && ((BlockStmt)iStmt).getStmts().size() == 0) continue;
            stmts.add(0, iStmt);
        }
        ListIterator i2 = this.getBody().iterator();
        while (i2.hasNext()) {
            ConstructorDec cDec;
            ConstructorCallExpr call;
            Object o = i2.next();
            if (!(o instanceof ConstructorDec) || (call = ((ConstructorBody)(cDec = (ConstructorDec)o).getBody()).getConstructorCall()) != null && !call.getIsSuper()) continue;
            Stmts newStmts = (Stmts)CopyWalker.copy(stmts);
            cDec.getBody().getStmts().addAll(0, newStmts);
        }
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
        walker.pushNonConstructorEnv();
        walker.pushTypeDec(this);
    }

    public ASTObject postThreading(LocalClassPass.ThreadingWalker walker) {
        walker.popTypeDec();
        walker.popEnv();
        return this;
    }

    protected void cgMember(ClassfileBuilder maker) {
        maker.delayInnerClassGeneration(this);
    }

    public File getPackageDir(File outputdir) {
        String packagename = this.getPackageName();
        if (this.getOptions().XtargetNearSource && outputdir == Options.getDefaultOutputDir()) {
            return new File(this.getSourceDirectoryName());
        }
        if (packagename == null) {
            return outputdir;
        }
        int lastDot = 0;
        int dot = 0;
        while ((dot = packagename.indexOf(46, lastDot)) != -1) {
            outputdir = new File(outputdir, packagename.substring(lastDot, dot));
            lastDot = dot + 1;
        }
        return new File(outputdir, packagename.substring(lastDot));
    }

    public final void generateBytecode(File outputDir) throws IOException {
        String filename = this.getExtendedId() + ".class";
        this.getCompiler().showMessage("  writing " + filename);
        this.getCompiler().beginSection("bcg:AST-directed");
        ClassfileBuilder cfb = new ClassfileBuilder(this.getCompiler());
        cfb.setSourceFile(this.getSourceLocation());
        if (!this.isConcrete()) {
            this.getModifiers().setInterface(true);
        }
        cfb.addAccessFlags(this.getModifiers().getAcceptableClassValue());
        cfb.setClassName((NameType)this.getType());
        cfb.setSuperClassName((NameType)this.getSuperClassType());
        Iterator i = this.getSuperInterfaceTypes().iterator();
        while (i.hasNext()) {
            NameType iface = (NameType)i.next();
            cfb.addInterface(iface);
        }
        ListIterator i2 = this.getBody().iterator();
        while (i2.hasNext()) {
            Dec memberDec = (Dec)i2.next();
            memberDec.cgMember(cfb);
        }
        this.getCompiler().beginSection("bcg:assembly");
        cfb.resolve();
        this.getCompiler().beginSection("bcg:output");
        File packagedir = this.getPackageDir(outputDir);
        packagedir.mkdirs();
        File outFile = new File(packagedir, filename);
        FileOutputStream fileStream = new FileOutputStream(outFile);
        DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(fileStream));
        cfb.writeTo(stream);
        stream.close();
        cfb.generateBytecodeForDelayedInnerClasses(outputDir);
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Modifiers _modifiers) {
        if (_modifiers != null) {
            _modifiers.setParent(this);
        }
        this.modifiers = _modifiers;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public TypeDs getSuperInterfaces() {
        return this.superInterfaces;
    }

    public void setSuperInterfaces(TypeDs _superInterfaces) {
        if (_superInterfaces != null) {
            _superInterfaces.setParent(this);
        }
        this.superInterfaces = _superInterfaces;
    }

    public Decs getBody() {
        return this.body;
    }

    public void setBody(Decs _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public TypeDec(SourceLocation location, Modifiers _modifiers, String _id, TypeDs _superInterfaces, Decs _body) {
        super(location);
        this.setModifiers(_modifiers);
        this.setId(_id);
        this.setSuperInterfaces(_superInterfaces);
        this.setBody(_body);
    }

    protected TypeDec(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.superInterfaces;
            }
            case 2: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "superInterfaces";
            }
            case 2: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setSuperInterfaces((TypeDs)child);
                return;
            }
            case 2: {
                this.setBody((Decs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "TypeDec(id: " + this.id + ")";
    }
}

