/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class TypeExpr
extends Expr {
    protected TypeD typeD;

    public Type discoverType() {
        return this.typeD.getType();
    }

    public void unparse(CodeWriter writer) {
        this.typeD.unparse(writer, true);
    }

    public Expr makeReference() {
        return (Expr)this.copy();
    }

    public void checkSpec() {
        super.checkSpec();
        if (this.fromSource() && this.getType() != null && this.getType().getTypeDec() != null && !this.getType().getTypeDec().isAccessible(this)) {
            this.showError("can't access " + this.getType().getTypeDec().toShortString());
            return;
        }
        ASTObject self = this;
        ASTObject parent = this.getParent();
        while (parent instanceof Expr) {
            if (parent instanceof CallExpr) {
                if (((CallExpr)parent).getExpr() != self || !((CallExpr)parent).getMethod().isStatic()) break;
                return;
            }
            if (parent instanceof FieldAccessExpr) {
                if (((FieldAccessExpr)parent).getExpr() != self || !((FieldAccessExpr)parent).getField().isStatic()) break;
                return;
            }
            if (!(parent instanceof ParenExpr)) break;
            self = parent;
            parent = parent.getParent();
        }
        this.showError("bad identifier");
    }

    protected void cgValue(CodeBuilder cb) {
    }

    protected void cgEffect(CodeBuilder cb) {
    }

    public TypeD getTypeD() {
        return this.typeD;
    }

    public void setTypeD(TypeD _typeD) {
        if (_typeD != null) {
            _typeD.setParent(this);
        }
        this.typeD = _typeD;
    }

    public TypeExpr(SourceLocation location, TypeD _typeD) {
        super(location);
        this.setTypeD(_typeD);
    }

    protected TypeExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        TypeExpr ret = new TypeExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeD;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeD";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeD((TypeD)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "TypeExpr()";
    }
}

