/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;
import org.aspectj.compiler.base.bcg.pool.ClassConstant;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;
import org.aspectj.compiler.base.bcg.pool.Utf8Constant;

public final class Attributes {
    ConstantPool pool;
    private List attributes = new ArrayList();
    PoolsAttribute exceptionAttribute = null;
    InnerClassesAttribute innerClassesAttribute = null;

    Attributes(ConstantPool pool) {
        this.pool = pool;
    }

    void addSyntheticAttribute() {
        this.attributes.add(new EmptyAttribute(this.pool.addUtf8("Synthetic")));
    }

    void addDeprecatedAttribute() {
        this.attributes.add(new EmptyAttribute(this.pool.addUtf8("Deprecated")));
    }

    void addSourceFileAttribute(String sourceFile) {
        this.attributes.add(new PoolAttribute(this.pool.addUtf8("SourceFile"), this.pool.addUtf8(sourceFile)));
    }

    void addSouceDebugExtensionAttribute(String data) {
        this.attributes.add(new SourceDebugExtensionAttribute(this.pool.addUtf8("SourceDebugExtension"), data));
    }

    void addConstantValueAttribute(Constant c) {
        this.attributes.add(new PoolAttribute(this.pool.addUtf8("ConstantValue"), c));
    }

    void addCodeAttribute(CodeBuilder cb) {
        this.attributes.add(new CodeAttribute(this.pool.addUtf8("Code"), cb));
    }

    void addLineNumberTableAttribute(Label[] pcs, int[] lines) {
        this.attributes.add(new LineNumberTableAttribute(this.pool.addUtf8("LineNumberTable"), pcs, lines));
    }

    void addLocalVariableTableAttribute(Label[] starts, Label[] ends, Constant[] names, Constant[] descriptors, int[] indices) {
        this.attributes.add(new LocalVariableTableAttribute(this.pool.addUtf8("LocalVariableTable"), starts, ends, names, descriptors, indices));
    }

    void addToExceptionsAttribute(NameType nameType) {
        if (this.exceptionAttribute == null) {
            this.exceptionAttribute = new PoolsAttribute(this.pool.addUtf8("Exceptions"));
            this.attributes.add(this.exceptionAttribute);
        }
        this.exceptionAttribute.add(this.pool.addClass(nameType));
    }

    void addToInnerClassesAttribute(NameType nameType) {
        if (this.innerClassesAttribute == null) {
            this.innerClassesAttribute = new InnerClassesAttribute(this.pool.addUtf8("InnerClasses"));
            this.attributes.add(this.innerClassesAttribute);
        }
        if (nameType.isInterface()) {
            nameType.getTypeDec().getModifiers().setInterface(true);
        }
        this.innerClassesAttribute.add(this.pool.addClassNoInnerCheck(nameType), nameType.isLocal() ? null : this.pool.addClass(nameType.getEnclosingType()), nameType.isAnonymous() ? null : this.pool.addUtf8(nameType.getId()), nameType.getTypeDec().getModifiers().getAcceptableInnerClassValue());
    }

    int getByteSize() {
        int s = 2;
        int i = 0;
        int len = this.attributes.size();
        while (i < len) {
            s += ((Attribute)this.attributes.get(i)).getByteSize();
            ++i;
        }
        return s;
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        stream.writeShort((short)this.attributes.size());
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            ((Attribute)i.next()).writeTo(stream);
        }
    }

    public String toString() {
        String s = "(Attr";
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            s = s + i.next().toString();
        }
        return s + ")";
    }

    void display(int indent, boolean inline) {
        System.err.print("(attributes");
        Attributes.display(this.attributes, indent += 2, inline);
        System.err.print(")");
    }

    static void display(List l, int indent, boolean inline) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Attribute c = (Attribute)i.next();
            Attributes.between(indent, inline);
            c.display(indent, inline);
        }
    }

    static void between(int indent, boolean inline) {
        if (inline) {
            System.err.print(" ");
        } else {
            System.err.println();
            int s = indent;
            while (s >= 0) {
                System.err.print(" ");
                --s;
            }
        }
    }

    void readFrom(DataInputStream stream) throws IOException {
        int count;
        int i = count = stream.readUnsignedShort();
        while (i > 0) {
            int s;
            int size;
            Attribute a;
            Utf8Constant name = (Utf8Constant)this.pool.get(stream.readUnsignedShort());
            int len = stream.readInt();
            String id = name.value;
            if ("ConstantValue".equals(id)) {
                this.attributes.add(new PoolAttribute(name, this.pool.get(stream.readUnsignedShort())));
            } else if ("SourceFile".equals(id)) {
                this.attributes.add(new PoolAttribute(name, this.pool.get(stream.readUnsignedShort())));
            } else if ("Code".equals(id)) {
                this.attributes.add(new EmptyAttribute(name));
                stream.skipBytes(len);
            } else if ("Exceptions".equals(id)) {
                a = new PoolsAttribute(name);
                size = stream.readUnsignedShort();
                s = size - 1;
                while (s >= 0) {
                    ((PoolsAttribute)a).add(this.pool.get(stream.readUnsignedShort()));
                    --s;
                }
                this.attributes.add(a);
            } else if ("InnerClasses".equals(id)) {
                a = new InnerClassesAttribute(name);
                size = stream.readUnsignedShort();
                s = size - 1;
                while (s >= 0) {
                    ((InnerClassesAttribute)a).add((ClassConstant)this.pool.get(stream.readUnsignedShort()), (ClassConstant)this.pool.get(stream.readUnsignedShort()), (Utf8Constant)this.pool.get(stream.readUnsignedShort()), stream.readUnsignedShort());
                    --s;
                }
                this.attributes.add(a);
            } else {
                this.attributes.add(new EmptyAttribute(name));
                stream.skipBytes(len);
            }
            --i;
        }
    }

    private class SourceDebugExtensionAttribute
    extends Attribute {
        byte[] data;

        SourceDebugExtensionAttribute(Constant name, String data) {
            super(name);
            try {
                this.data = data.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }

        int getByteSize() {
            return 6 + this.data.length;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            this.name.writeIndex(stream);
            int len = this.data.length;
            stream.writeInt(len);
            stream.write(this.data);
        }

        public String toString() {
            try {
                return "(SourceDebugExtensionAttribute \"" + new String(this.data, "UTF-8") + "\")";
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }

        void display(int indent, boolean inline) {
            System.err.println(this);
        }
    }

    private class InnerClassesAttribute
    extends Attribute {
        List inners = new ArrayList();
        List outers = new ArrayList();
        List names = new ArrayList();
        List modifiers = new ArrayList();

        InnerClassesAttribute(Constant name) {
            super(name);
        }

        void add(ClassConstant inner, ClassConstant outer, Utf8Constant name, int mods) {
            this.inners.add(inner);
            this.outers.add(outer);
            this.names.add(name);
            this.modifiers.add(new Integer(mods));
        }

        int getByteSize() {
            return 8 + 8 * this.inners.size();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            this.name.writeIndex(stream);
            int len = this.inners.size();
            stream.writeInt(8 * len + 2);
            stream.writeShort(len);
            int i = 0;
            while (i < len) {
                ConstantPool.writeIndex((ClassConstant)this.inners.get(i), stream);
                ConstantPool.writeIndex((ClassConstant)this.outers.get(i), stream);
                ConstantPool.writeIndex((Utf8Constant)this.names.get(i), stream);
                stream.writeShort((Integer)this.modifiers.get(i));
                ++i;
            }
        }

        public String toString() {
            return "(innerclassattribute)";
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name);
            int len = this.inners.size();
            int i = 0;
            while (i < len) {
                Attributes.between(indent + 2, inline);
                System.err.print("(class ");
                ((ClassConstant)this.inners.get(i)).display(0, true);
                Attributes.between(indent + 4, inline);
                System.err.print("(inside ");
                ((ClassConstant)this.outers.get(i)).display(0, true);
                System.err.print(")");
                Attributes.between(indent + 4, inline);
                System.err.print("(knownAs ");
                ((Utf8Constant)this.names.get(i)).display(0, true);
                System.err.print(")");
                Attributes.between(indent + 4, inline);
                System.err.print("(modifiers " + Modifier.toString((Integer)this.modifiers.get(i)) + ")");
                System.err.print(")");
                ++i;
            }
            System.err.print(")");
        }
    }

    private class LocalVariableTableAttribute
    extends Attribute {
        Label[] starts;
        Label[] ends;
        Constant[] names;
        Constant[] descriptors;
        int[] indices;

        LocalVariableTableAttribute(Constant name, Label[] starts, Label[] ends, Constant[] names, Constant[] descriptors, int[] indices) {
            super(name);
            this.starts = starts;
            this.ends = ends;
            this.names = names;
            this.descriptors = descriptors;
            this.indices = indices;
        }

        int getByteSize() {
            return 8 + 10 * this.starts.length;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            int len = this.starts.length;
            this.name.writeIndex(stream);
            stream.writeInt(10 * len + 2);
            stream.writeShort(len);
            int i = 0;
            while (i < len) {
                int start = this.starts[i].getPc();
                int end = this.ends[i].getPc();
                stream.writeShort((short)start);
                stream.writeShort((short)(end - start));
                this.names[i].writeIndex(stream);
                this.descriptors[i].writeIndex(stream);
                stream.writeShort((short)this.indices[i]);
                ++i;
            }
        }

        public String toString() {
            String s = " (" + this.name;
            return s + ")";
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name);
            int i = 0;
            while (i < this.starts.length) {
                Attributes.between(indent + 2, inline);
                System.err.print("(" + this.names[i] + " " + this.descriptors[i] + " at " + this.indices[i] + " from " + this.starts[i].getPc() + " to " + this.ends[i].getPc() + ")");
                ++i;
            }
            System.err.print(")");
        }
    }

    private class LineNumberTableAttribute
    extends Attribute {
        Label[] pcs;
        int[] lines;

        LineNumberTableAttribute(Constant name, Label[] pcs, int[] lines) {
            super(name);
            this.pcs = pcs;
            this.lines = lines;
        }

        int getByteSize() {
            return 8 + 4 * this.pcs.length;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            int len = this.pcs.length;
            this.name.writeIndex(stream);
            stream.writeInt(4 * len + 2);
            stream.writeShort(len);
            int i = 0;
            while (i < len) {
                stream.writeShort((short)this.pcs[i].getPc());
                stream.writeShort((short)this.lines[i]);
                ++i;
            }
        }

        public String toString() {
            String s = " (" + this.name;
            return s + ")";
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name);
            int i = 0;
            while (i < this.pcs.length) {
                Attributes.between(indent + 2, inline);
                System.err.print("((pc " + this.pcs[i].getPc() + ") (line " + this.lines[i] + "))");
                ++i;
            }
            System.err.print(")");
        }
    }

    private class PoolsAttribute
    extends Attribute {
        List data = new ArrayList();

        PoolsAttribute(Constant name) {
            super(name);
        }

        void add(Constant constant) {
            this.data.add(constant);
        }

        int getByteSize() {
            return 8 + 2 * this.data.size();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            this.name.writeIndex(stream);
            stream.writeInt(2 * (this.data.size() + 1));
            stream.writeShort(this.data.size());
            Iterator i = this.data.iterator();
            while (i.hasNext()) {
                ((Constant)i.next()).writeIndex(stream);
            }
        }

        public String toString() {
            String s = " (" + this.name;
            Iterator i = this.data.iterator();
            while (i.hasNext()) {
                s = s + " " + (Constant)i.next();
            }
            return s + ")";
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name);
            ConstantPool.display(this.data, indent + 2, inline);
            System.err.print(")");
        }
    }

    private class CodeAttribute
    extends Attribute {
        CodeBuilder cb;

        CodeAttribute(Constant name, CodeBuilder cb) {
            super(name);
            this.cb = cb;
        }

        int getByteSize() {
            return 6 + this.cb.getByteSize();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            this.name.writeIndex(stream);
            stream.writeInt(this.cb.getByteSize());
            this.cb.writeTo(stream);
        }

        public String toString() {
            return " (" + this.name + " " + this.cb + ")";
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name);
            Attributes.between(indent + 2, inline);
            this.cb.display(indent + 2, inline);
            System.err.print(")");
        }
    }

    private class PoolAttribute
    extends Attribute {
        Constant data;

        PoolAttribute(Constant name, Constant data) {
            super(name);
            this.data = data;
        }

        int getByteSize() {
            return 8;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            this.name.writeIndex(stream);
            stream.writeInt(2);
            this.data.writeIndex(stream);
        }

        public String toString() {
            return " (" + this.name + " " + this.data + ")";
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name);
            Attributes.between(0, true);
            this.data.display(indent + 2, inline);
            System.err.print(")");
        }
    }

    private class EmptyAttribute
    extends Attribute {
        EmptyAttribute(Constant name) {
            super(name);
        }

        int getByteSize() {
            return 6;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            this.name.writeIndex(stream);
            stream.writeInt(0);
        }

        public String toString() {
            return " " + this.name;
        }

        void display(int indent, boolean inline) {
            System.err.print("(" + this.name + ")");
        }
    }

    private abstract class Attribute {
        Constant name;

        Attribute(Constant name) {
            this.name = name;
        }

        abstract void writeTo(DataOutputStream var1) throws IOException;

        abstract void display(int var1, boolean var2);

        abstract int getByteSize();
    }
}

