/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bcg.Attributes;
import org.aspectj.compiler.base.bcg.FieldBuilder;
import org.aspectj.compiler.base.bcg.MethodBuilder;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public class ClassfileBuilder {
    private JavaCompiler compiler;
    private int magic = -889275714;
    private short minorVersion = (short)3;
    private short majorVersion = (short)45;
    ConstantPool pool = new ConstantPool(this);
    private int accessFlags = 0;
    private Constant thisClass;
    private Constant superClass;
    private List interfaces = new ArrayList();
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private Attributes attributes = new Attributes(this.pool);
    private List innerTypeDecs = new ArrayList();
    private HashSet innerClasses = new HashSet();
    SourceFile sourceFiles;

    public ClassfileBuilder(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    public JavaCompiler getCompiler() {
        return this.compiler;
    }

    public void addAccessFlags(int newFlags) {
        this.accessFlags |= newFlags;
    }

    public void setClassName(NameType nameType) {
        this.thisClass = this.pool.addClass(nameType);
    }

    public void setSuperClassName(NameType nameType) {
        this.superClass = this.pool.addClass(nameType);
    }

    public void addInterface(NameType nameType) {
        this.interfaces.add(this.pool.addClass(nameType));
    }

    public FieldBuilder getFieldBuilder() {
        return new FieldBuilder(this);
    }

    public void addField(FieldBuilder maker) {
        this.fields.add(maker);
    }

    public MethodBuilder getMethodBuilder() {
        return new MethodBuilder(this);
    }

    public void addMethod(MethodBuilder maker) {
        this.methods.add(maker);
    }

    public void setSynthetic() {
        this.attributes.addSyntheticAttribute();
    }

    public void setSourceFile(SourceLocation loc) {
        this.sourceFiles = new SourceFile(loc);
    }

    public void setSourceDebugExtension(String data) {
        this.attributes.addSouceDebugExtensionAttribute(data);
    }

    public void addInnerClassRef(NameType nameType) {
        if (!this.innerClasses.contains(nameType)) {
            this.innerClasses.add(nameType);
            this.attributes.addToInnerClassesAttribute(nameType);
        }
    }

    public void delayInnerClassGeneration(TypeDec typeDec) {
        this.addInnerClassRef(typeDec.getNameType());
        this.innerTypeDecs.add(typeDec);
    }

    public void generateBytecodeForDelayedInnerClasses(File outputDir) throws IOException {
        Iterator i = this.innerTypeDecs.iterator();
        while (i.hasNext()) {
            TypeDec typeDec = (TypeDec)i.next();
            typeDec.generateBytecode(outputDir);
        }
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        stream.writeInt(this.magic);
        stream.writeShort(this.minorVersion);
        stream.writeShort(this.majorVersion);
        this.pool.writeTo(stream);
        stream.writeShort(this.accessFlags);
        this.thisClass.writeIndex(stream);
        this.superClass.writeIndex(stream);
        stream.writeShort((short)this.interfaces.size());
        Iterator i = this.interfaces.iterator();
        while (i.hasNext()) {
            Constant iface = (Constant)i.next();
            iface.writeIndex(stream);
        }
        stream.writeShort((short)this.fields.size());
        Iterator i2 = this.fields.iterator();
        while (i2.hasNext()) {
            FieldBuilder field = (FieldBuilder)i2.next();
            field.writeTo(stream);
        }
        stream.writeShort((short)this.methods.size());
        Iterator i3 = this.methods.iterator();
        while (i3.hasNext()) {
            MethodBuilder method = (MethodBuilder)i3.next();
            method.writeTo(stream);
        }
        this.attributes.writeTo(stream);
        if (this.compiler.getOptions().bcgtrace) {
            this.print();
        }
    }

    void print() {
        this.display(0, false);
        System.err.println();
    }

    static void between(int indent, boolean inline) {
        if (inline) {
            System.err.print(" ");
        } else {
            System.err.println();
            int s = indent;
            while (s >= 0) {
                System.err.print(" ");
                --s;
            }
        }
    }

    void display(int indent, boolean inline) {
        System.err.print("(class ");
        this.thisClass.display(0, true);
        ClassfileBuilder.between(indent += 2, inline);
        System.err.print("(modifiers " + Modifier.toString(this.accessFlags) + ")");
        ClassfileBuilder.between(indent, inline);
        System.err.print("(extends ");
        this.superClass.display(0, true);
        System.err.print(")");
        ClassfileBuilder.between(indent, inline);
        System.err.print("(implements");
        ConstantPool.display(this.interfaces, 0, true);
        System.err.print(")");
        ClassfileBuilder.between(indent, inline);
        System.err.print("(members");
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            FieldBuilder b = (FieldBuilder)i.next();
            ClassfileBuilder.between(indent + 2, inline);
            b.display(indent + 2, inline);
        }
        Iterator i2 = this.methods.iterator();
        while (i2.hasNext()) {
            MethodBuilder b = (MethodBuilder)i2.next();
            ClassfileBuilder.between(indent + 2, inline);
            b.display(indent + 2, inline);
        }
        System.err.print(")");
        ClassfileBuilder.between(indent, inline);
        this.attributes.display(indent, inline);
        ClassfileBuilder.between(indent, inline);
        this.pool.display(indent, inline);
        System.err.print(")");
    }

    public void resolve() {
        String simpleName;
        this.pool.resolve();
        int offset = 0;
        int fileNumber = 0;
        SourceFile t = this.sourceFiles;
        while (t != null) {
            int i = t.i;
            t.offset = offset;
            t.fileNumber = fileNumber++;
            offset = offset + i + 1000 - i % 1000;
            t = t.next;
        }
        Iterator i = this.methods.iterator();
        while (i.hasNext()) {
            MethodBuilder m = (MethodBuilder)i.next();
            m.resolve();
        }
        String s = simpleName = this.sourceFiles.getSimpleName();
        SourceFile t2 = this.sourceFiles.next;
        while (t2 != null) {
            s = s + ";" + t2.getFullName() + '[' + t2.offset / 1000 + "k]";
            t2 = t2.next;
        }
        this.attributes.addSourceFileAttribute(s);
        this.attributes.addSouceDebugExtensionAttribute(this.createSourceDebugExtensionData(simpleName));
    }

    private String createSourceDebugExtensionData(String simpleName) {
        StringBuffer s = new StringBuffer("SMAP\n");
        s.append(simpleName + "\n");
        s.append("AspectJ\n");
        s.append("*S AspectJ\n");
        s.append("*F\n");
        SourceFile t = this.sourceFiles;
        while (t != null) {
            if (t.getFileNumber() != 0) {
                if (t.sourcePackage == null) {
                    s.append(t.getFileNumber() + " " + t.getSimpleName() + "\n");
                } else {
                    s.append("+ " + t.getFileNumber() + " " + t.getSimpleName() + "\n" + t.getFullName() + "\n");
                }
            }
            t = t.next;
        }
        s.append("*L\n");
        SourceFile t2 = this.sourceFiles;
        while (t2 != null) {
            if (t2.getFileNumber() != 0) {
                s.append("1#" + t2.getFileNumber() + "," + t2.i + ":" + (t2.offset + 1) + ",1\n");
            }
            t2 = t2.next;
        }
        s.append("*E\n");
        return s.toString();
    }

    SourceFile getSourceFile(SourceLocation loc) {
        if (!loc.hasSource()) {
            return null;
        }
        return this.sourceFiles.get(loc);
    }

    void readFrom(DataInputStream stream) throws IOException {
        int magic = stream.readInt();
        this.minorVersion = (short)stream.readUnsignedShort();
        this.majorVersion = (short)stream.readUnsignedShort();
        this.pool.readFrom(stream);
        this.accessFlags = stream.readUnsignedShort();
        this.thisClass = this.pool.get(stream.readUnsignedShort());
        this.superClass = this.pool.get(stream.readUnsignedShort());
        int i = stream.readUnsignedShort();
        while (i > 0) {
            this.interfaces.add(this.pool.get(stream.readUnsignedShort()));
            --i;
        }
        int i2 = stream.readUnsignedShort();
        while (i2 > 0) {
            this.fields.add(this.getFieldBuilder().readFrom(stream));
            --i2;
        }
        int i3 = stream.readUnsignedShort();
        while (i3 > 0) {
            this.methods.add(this.getMethodBuilder().readFrom(stream));
            --i3;
        }
        this.attributes.readFrom(stream);
    }

    public static void main(String[] args) throws Exception {
        ClassfileBuilder cfb = new ClassfileBuilder(null);
        cfb.readFrom(new DataInputStream(new FileInputStream(args[0])));
        cfb.print();
    }

    static class SourceFile {
        SourceFile next = null;
        final String sourcePackage;
        final String sourceFile;
        int fileNumber = 0;
        int i = 0;
        int offset = 0;

        String getSimpleName() {
            return this.sourceFile;
        }

        String getFullName() {
            if (this.sourcePackage == null) {
                return this.sourceFile;
            }
            return this.sourcePackage.replace('.', '/') + '/' + this.sourceFile;
        }

        SourceFile(SourceLocation loc) {
            if (loc.hasSource()) {
                this.sourcePackage = loc.getCompilationUnit().getPackageName();
                this.sourceFile = loc.getSourceFile().getName();
            } else {
                this.sourcePackage = null;
                this.sourceFile = "NoSourceFile";
            }
        }

        SourceFile(SourceLocation loc, int i) {
            this(loc);
            this.i = i;
        }

        int getFileNumber() {
            return this.fileNumber + 1;
        }

        int getOutputLine(int line) {
            return line + this.i;
        }

        SourceFile get(SourceLocation loc) {
            String currPackage = loc.getCompilationUnit().getPackageName();
            boolean bl = this.sourcePackage == null ? currPackage == null : this.sourcePackage.equals(currPackage);
            if (bl && this.sourceFile.equals(loc.getSourceFile().getName())) {
                int line = loc.getBeginLine();
                if (line > this.i) {
                    this.i = line;
                }
                return this;
            }
            if (this.next == null) {
                this.next = new SourceFile(loc, loc.getBeginLine());
                return this.next;
            }
            return this.next.get(loc);
        }
    }
}

