/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public class FloatConstant
extends Constant {
    float value;

    FloatConstant() {
    }

    FloatConstant(float value) {
        this.value = value;
    }

    void writeTo(DataOutputStream stream) throws IOException {
        stream.writeByte(4);
        stream.writeFloat(this.value);
    }

    public String toString() {
        return Constant.rep(this.getIndex(), "(float " + this.value + ")");
    }

    public boolean equals(Object other) {
        if (!(other instanceof FloatConstant)) {
            return false;
        }
        FloatConstant o = (FloatConstant)other;
        return this.value == o.value;
    }

    public int hashCode() {
        return (int)(this.value * 3.0f);
    }

    void readFrom(DataInputStream stream, ConstantPool pool) throws IOException {
        this.value = stream.readFloat();
    }
}

