/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;
import org.aspectj.compiler.base.bcg.pool.Utf8Constant;

public class NameAndTypeConstant
extends Constant {
    Utf8Constant name;
    Utf8Constant descriptor;

    NameAndTypeConstant() {
    }

    NameAndTypeConstant(Utf8Constant name, Utf8Constant descriptor) {
        this.name = name;
        this.descriptor = descriptor;
    }

    void writeTo(DataOutputStream stream) throws IOException {
        stream.writeByte(12);
        this.name.writeIndex(stream);
        this.descriptor.writeIndex(stream);
    }

    public String toString() {
        return Constant.rep(this.getIndex(), "(nameAndType " + this.name + " " + this.descriptor + ")");
    }

    public boolean equals(Object other) {
        if (!(other instanceof NameAndTypeConstant)) {
            return false;
        }
        NameAndTypeConstant o = (NameAndTypeConstant)other;
        return this.name == o.name && this.descriptor == o.descriptor;
    }

    public int hashCode() {
        return this.name.hashCode() + this.descriptor.hashCode() + 12;
    }

    void readFrom(DataInputStream stream, ConstantPool pool) throws IOException {
        this.name = (Utf8Constant)pool.get(stream.readUnsignedShort(), new Utf8Constant());
        this.descriptor = (Utf8Constant)pool.get(stream.readUnsignedShort(), new Utf8Constant());
    }
}

