/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bytecode.InvalidClassFileException;

class ConstantPool {
    Entry[] constants;
    static final int CLASS_TAG = 7;
    static final int FIELD_REF_TAG = 9;
    static final int METHOD_REF_TAG = 10;
    static final int INTERFACE_METHOD_REF_TAG = 11;
    static final int STRING_TAG = 8;
    static final int INTEGER_TAG = 3;
    static final int FLOAT_TAG = 4;
    static final int LONG_TAG = 5;
    static final int DOUBLE_TAG = 6;
    static final int NAME_AND_TYPE_TAG = 12;
    static final int UTF_TAG = 1;

    ConstantPool() {
    }

    public Entry getEntry(int index) {
        return this.constants[index];
    }

    public Class getClass(int index) {
        return (Class)this.constants[index];
    }

    public UTF getUTF(int index) {
        if (index > this.constants.length) {
            throw new InvalidClassFileException("invalid constant: " + index);
        }
        return (UTF)this.constants[index];
    }

    private UTF readUTF(DataInputStream stream) throws IOException {
        int index = stream.readUnsignedShort();
        Entry entry = this.constants[index];
        if (entry == null) {
            this.constants[index] = entry = new UTF();
        }
        return (UTF)entry;
    }

    private Class readClass(DataInputStream stream) throws IOException {
        int index = stream.readUnsignedShort();
        Entry entry = this.constants[index];
        if (entry == null) {
            this.constants[index] = entry = new Class();
        }
        return (Class)entry;
    }

    private NameAndType readNameAndType(DataInputStream stream) throws IOException {
        int index = stream.readUnsignedShort();
        Entry entry = this.constants[index];
        if (entry == null) {
            this.constants[index] = entry = new NameAndType();
        }
        return (NameAndType)entry;
    }

    public Entry readEntry(int tag, DataInputStream stream) throws IOException {
        Entry entry = null;
        switch (tag) {
            case 7: {
                entry = new Class();
                break;
            }
            case 9: {
                entry = new FieldRef();
                break;
            }
            case 10: {
                entry = new MethodRef();
                break;
            }
            case 11: {
                entry = new InterfaceMethodRef();
                break;
            }
            case 8: {
                entry = new String();
                break;
            }
            case 3: {
                entry = new Integer();
                break;
            }
            case 4: {
                entry = new Float();
                break;
            }
            case 5: {
                entry = new Long();
                break;
            }
            case 6: {
                entry = new Double();
                break;
            }
            case 12: {
                entry = new NameAndType();
                break;
            }
            case 1: {
                entry = new UTF();
            }
        }
        entry.readFrom(stream);
        return entry;
    }

    public void readFrom(DataInputStream stream) throws IOException {
        int constantCount = stream.readUnsignedShort();
        this.constants = new Entry[constantCount];
        int index = 1;
        while (index < constantCount) {
            int tag = stream.readUnsignedByte();
            Entry entry = this.constants[index];
            if (entry != null) {
                entry.readFrom(stream);
            } else {
                this.constants[index] = entry = this.readEntry(tag, stream);
            }
            if (tag == 6 || tag == 5) {
                ++index;
            }
            ++index;
        }
    }

    class UTF
    extends Entry {
        java.lang.String value;

        UTF() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = stream.readUTF();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(1);
            stream.writeUTF(this.value);
        }

        public java.lang.String toString() {
            return "UTF(" + this.value + ")";
        }
    }

    class NameAndType
    extends Entry {
        UTF name;
        UTF descriptor;

        NameAndType() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.name = ConstantPool.this.readUTF(stream);
            this.descriptor = ConstantPool.this.readUTF(stream);
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(12);
            this.name.writeTo(stream);
            this.descriptor.writeTo(stream);
        }

        public java.lang.String toString() {
            return "NameAndType(" + this.name + " " + this.descriptor + ")";
        }
    }

    class Double
    extends Entry {
        double value;

        Double() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = stream.readDouble();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(6);
            stream.writeDouble(this.value);
        }
    }

    class Long
    extends Entry {
        long value;

        Long() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = stream.readLong();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(5);
            stream.writeLong(this.value);
        }
    }

    class Float
    extends Entry {
        float value;

        Float() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = stream.readFloat();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(4);
            stream.writeFloat(this.value);
        }
    }

    class Integer
    extends Entry {
        int value;

        Integer() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = stream.readInt();
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(3);
            stream.writeInt(this.value);
        }
    }

    class String
    extends Entry {
        UTF value;

        String() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = ConstantPool.this.readUTF(stream);
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(8);
            this.value.writeIndex(stream);
        }
    }

    class InterfaceMethodRef
    extends MemberRef {
        InterfaceMethodRef() {
        }

        int getTag() {
            return 11;
        }
    }

    class MethodRef
    extends MemberRef {
        MethodRef() {
        }

        int getTag() {
            return 10;
        }
    }

    class FieldRef
    extends MemberRef {
        FieldRef() {
        }

        int getTag() {
            return 9;
        }
    }

    abstract class MemberRef
    extends Entry {
        Class _class;
        NameAndType nameAndType;

        MemberRef() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this._class = ConstantPool.this.readClass(stream);
            this.nameAndType = ConstantPool.this.readNameAndType(stream);
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.getTag());
            this._class.writeIndex(stream);
            this.nameAndType.writeIndex(stream);
        }

        abstract int getTag();

        public java.lang.String toString() {
            return "MemberRef(" + this._class + " " + this.nameAndType + ")";
        }
    }

    class Class
    extends Entry {
        UTF name;

        Class() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.name = ConstantPool.this.readUTF(stream);
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(7);
            this.name.writeIndex(stream);
        }

        public java.lang.String getName() {
            return this.name.value.replace('/', '.');
        }

        public java.lang.String toString() {
            if (this.name == null) {
                return "Class()";
            }
            return "Class(" + this.name.value + ")";
        }
    }

    abstract class Entry {
        int index;

        Entry() {
        }

        void writeIndex(DataOutputStream stream) throws IOException {
            stream.writeShort(this.index);
        }

        abstract void readFrom(DataInputStream var1) throws IOException;

        abstract void writeTo(DataOutputStream var1) throws IOException;

        public int getIndex() {
            return this.index;
        }
    }
}

