/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bytecode.ClassManager;

class DirectoryClassManager
extends ClassManager {
    File directory;

    public DirectoryClassManager(JavaCompiler compiler, File directory) {
        super(compiler);
        this.directory = directory;
    }

    public ClassManager makeSubPackageManager(String subPackageName) {
        File dir = new File(this.directory, subPackageName);
        if (!dir.isDirectory()) {
            return null;
        }
        return new DirectoryClassManager(this.getCompiler(), dir);
    }

    public TypeDec findTypeDec(String name) {
        File testFile = new File(this.directory, name + ".class");
        if (name.equals("nul")) {
            return null;
        }
        if (testFile.isFile()) {
            try {
                return this.makeTypeDec(name, new FileInputStream(testFile));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public Collection getAllPossibleTypeNames() {
        ArrayList temp = new ArrayList();
        this.collectNames(this.directory, Collections.EMPTY_LIST, temp);
        return temp;
    }

    private void collectNames(File directory, List prefixName, Collection names) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        int i = files.length - 1;
        while (i >= 0) {
            File f = files[i];
            if (f.isDirectory()) {
                this.collectNames(f, this.newList(prefixName, f.getName()), names);
            } else if (this.isClassFile(f)) {
                names.add(this.newList(prefixName, this.filenameToClassName(f.getName())));
            }
            --i;
        }
    }

    private List newList(List left, Object right) {
        ArrayList<Object> temp = new ArrayList<Object>(left);
        temp.add(right);
        return temp;
    }

    private List newList(List left, List right) {
        ArrayList temp = new ArrayList(left);
        temp.addAll(right);
        return temp;
    }

    private boolean isClassFile(File f) {
        return f.isFile() && f.getName().toLowerCase().endsWith(".class");
    }

    public String toString() {
        return "dir(" + this.directory + ")";
    }

    protected String getPathString() {
        return this.directory.toString();
    }
}

