/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.cst;

import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Type;

public abstract class Scope
extends CompilerObject {
    private Scope parent;

    public Scope(JavaCompiler compiler, Scope parent) {
        super(compiler);
        this.parent = parent;
    }

    public final Scope getStackParent() {
        return this.parent;
    }

    public Scope getParent() {
        return this.parent;
    }

    public void setStackParent(Scope p) {
        this.parent = p;
    }

    public Type findType(String name, ASTObject fromWhere) {
        return this.getParent().findType(name, fromWhere);
    }

    public Expr bindUnqualifiedName(String name, ASTObject fromWhere) {
        return this.getParent().bindUnqualifiedName(name, fromWhere);
    }

    public Type findMethodLookupType(String name, ASTObject fromWhere) {
        return this.getParent().findMethodLookupType(name, fromWhere);
    }

    public String shortToString() {
        return "scope";
    }

    public String toString() {
        String ret = this.shortToString();
        if (this.getStackParent() != null) {
            ret = ret + "<-" + this.getStackParent().toString();
        }
        return ret;
    }
}

