/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import java.math.BigDecimal;
import org.aspectj.compiler.base.ast.DoubleLiteralExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.parser.Literal;

class DoubleLiteral
extends Literal {
    public double value;

    public DoubleLiteral(String image) {
        super(image, 17);
    }

    public String getValueImage() {
        if (this.image.endsWith("D") || this.image.endsWith("d")) {
            return this.image.substring(0, this.image.length() - 1);
        }
        return this.image;
    }

    public Expr getExpr(SourceLocation source) {
        DoubleLiteralExpr ret;
        try {
            this.value = Double.valueOf(this.getValueImage());
            ret = new DoubleLiteralExpr(source, this.value);
            if (this.value == 0.0) {
                BigDecimal bd = new BigDecimal(this.getValueImage());
                if (bd.compareTo(new BigDecimal("0")) != 0) {
                    ret.showError("non-zero literal rounds to 0");
                }
            } else if (this.value == Double.POSITIVE_INFINITY || this.value == Double.NEGATIVE_INFINITY) {
                ret.showError("floating point literal rounds to IEEE infinity");
            }
        }
        catch (NumberFormatException nfe) {
            source.showError("illegal floating point literal format");
            ret = new DoubleLiteralExpr(source, 0.0);
        }
        return ret;
    }
}

