/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.parser.CharacterLiteral;
import org.aspectj.compiler.base.parser.Comment;
import org.aspectj.compiler.base.parser.DoubleLiteral;
import org.aspectj.compiler.base.parser.FloatLiteral;
import org.aspectj.compiler.base.parser.IntegerLiteral;
import org.aspectj.compiler.base.parser.JavaConstants;
import org.aspectj.compiler.base.parser.LongLiteral;
import org.aspectj.compiler.base.parser.ParseException;
import org.aspectj.compiler.base.parser.SourceInfo;
import org.aspectj.compiler.base.parser.StringLiteral;
import org.aspectj.compiler.base.parser.Token;

public class JavaTokenizer
extends CompilerObject
implements JavaConstants {
    char[] text;
    int index = 0;
    int startIndex = 0;
    public Token specialToken = null;
    private static State beginState = new ArrayState();
    static Map knownOperators = new HashMap();
    private static final int OFFSET = 100;
    private static final int FIRST_LINE_GUESS = 500;
    private static final int LINE_GUESS_MULTIPLE = 4;
    int nChars;
    private static final int BUF_SIZE = 4096;
    public SourceInfo sourceInfo;

    void cleanup(boolean fully) {
        this.specialToken = null;
        this.text = null;
    }

    protected final void newLine() {
    }

    String getImage() {
        return new String(this.text, this.startIndex, this.index - this.startIndex);
    }

    String getImage(int startOffset, int endOffset) {
        return new String(this.text, this.startIndex + startOffset, this.index - (this.startIndex + startOffset) + endOffset);
    }

    public final Token getNextToken() {
        return this.nextToken();
    }

    public Token nextToken() {
        Token token;
        try {
            token = this.internalNextToken();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            token = new Token(0, "EOF", false);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            System.err.println("rt error at: " + this.index + ", " + this.sourceInfo.getLine(this.index));
            throw re;
        }
        catch (Error er) {
            System.err.println("error at: " + this.index + ", " + this.sourceInfo.getLine(this.index));
            throw er;
        }
        token.startPosition = this.startIndex;
        token.endPosition = this.index;
        token.specialToken = this.specialToken;
        this.specialToken = null;
        this.startIndex = this.index;
        return token;
    }

    private final char peekChar() {
        return this.peekChar(0);
    }

    private final char peekChar(int offset) {
        return this.text[this.index + offset];
    }

    private final char eatChar() {
        return this.text[this.index++];
    }

    private final void skipChars(int n) {
        this.index += n;
    }

    private final void skipChar() {
        ++this.index;
    }

    public Token internalNextToken() {
        block11: while (true) {
            switch (this.peekChar()) {
                case '\n': {
                    this.eatChar();
                    ++this.startIndex;
                    continue block11;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    this.eatChar();
                    ++this.startIndex;
                    continue block11;
                }
                case '/': {
                    Comment comment;
                    char peekChar = this.peekChar(1);
                    if (peekChar == '/') {
                        comment = this.getSingleLineComment();
                    } else if (peekChar == '*') {
                        try {
                            if (this.peekChar(2) == '*') {
                                comment = this.getDocumentationComment();
                            }
                            comment = this.getTraditionalComment();
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new ParseException(this.startIndex, this.sourceInfo, "unclosed comment");
                        }
                    } else {
                        return this.getToken();
                    }
                    if (comment != null) {
                        comment.specialToken = this.specialToken;
                        comment.startPosition = this.startIndex;
                        comment.endPosition = this.index;
                        this.specialToken = comment;
                    }
                    this.startIndex = this.index;
                    continue block11;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.getNumericLiteral();
                }
                case '.': {
                    char peekChar = this.peekChar(1);
                    if (peekChar >= '0' && peekChar <= '9') {
                        return this.getNumericLiteral();
                    }
                    return this.getToken();
                }
                case '\"': {
                    return this.getStringLiteral();
                }
                case '\'': {
                    return this.getCharacterLiteral();
                }
            }
            break;
        }
        return this.getToken();
    }

    public Token scanTillMatched(int kind) {
        int depth = 1;
        block8: while (true) {
            switch (this.eatChar()) {
                case '\t': 
                case '\n': 
                case '\f': 
                case ' ': {
                    continue block8;
                }
                case '/': {
                    char peekChar = this.peekChar();
                    if (peekChar == '/') {
                        while (this.eatChar() != '\n') {
                        }
                        continue block8;
                    }
                    if (peekChar != '*') continue block8;
                    this.skipChar();
                    while (this.eatChar() != '*' || this.peekChar() != '/') {
                    }
                    this.skipChar();
                    continue block8;
                }
                case '\"': {
                    this.skipStringLiteral();
                    continue block8;
                }
                case '\'': {
                    this.skipCharacterLiteral();
                    continue block8;
                }
                default: {
                    continue block8;
                }
                case '{': {
                    if (kind != 24) continue block8;
                    ++depth;
                    continue block8;
                }
                case '}': 
            }
            if (kind == 24 && --depth == 0) break;
        }
        Token token = new Token(24, "}", false);
        token.startPosition = this.index;
        token.endPosition = this.index;
        token.specialToken = null;
        this.specialToken = null;
        this.startIndex = this.index;
        return token;
    }

    private Comment getSingleLineComment() {
        this.skipChars(2);
        while (this.eatChar() != '\n') {
        }
        Comment ret = new Comment(this.getImage());
        ret.kind = 9;
        return ret;
    }

    private Comment getTraditionalComment() {
        char ch;
        this.skipChars(2);
        while ((ch = this.eatChar()) != '*' || this.peekChar() != '/') {
        }
        this.eatChar();
        Comment ret = new Comment(this.getImage());
        ret.kind = 11;
        return ret;
    }

    private Comment getDocumentationComment() {
        if (this.peekChar(3) == '/') {
            this.skipChars(4);
            Comment ret = new Comment("");
            ret.kind = 10;
            return ret;
        }
        this.skipChars(1);
        Comment ret = this.getTraditionalComment();
        ret.kind = 10;
        return ret;
    }

    private ParseException tokenError() {
        return this.tokenError("illegal character");
    }

    private ParseException tokenError(String message) {
        return new ParseException(this.index, this.sourceInfo, message);
    }

    private Token getNumericLiteral() {
        char ch = this.eatChar();
        int radix = 10;
        int startOffset = 0;
        if (ch == '0') {
            char peekChar = this.peekChar();
            if (peekChar == 'x' || peekChar == 'X') {
                this.eatChar();
                ch = this.eatChar();
                radix = 16;
                startOffset = 2;
            } else if (peekChar >= '0' && peekChar <= '7') {
                radix = 8;
                startOffset = 1;
            } else {
                startOffset = 0;
            }
        }
        while (Character.digit(ch, radix) != -1) {
            ch = this.eatChar();
        }
        switch (ch) {
            case 'L': 
            case 'l': {
                return new LongLiteral(this.getImage(startOffset, -1), radix);
            }
            case '.': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'd': 
            case 'e': 
            case 'f': {
                if (radix == 16) {
                    throw this.tokenError();
                }
                radix = 10;
                this.skipChars(-1);
                return this.finishFloatLiteral();
            }
        }
        this.skipChars(-1);
        return new IntegerLiteral(this.getImage(startOffset, 0), radix);
    }

    private Token finishFloatLiteral() {
        boolean seenDot = false;
        boolean seenExponent = false;
        block7: while (true) {
            switch (this.eatChar()) {
                case 'F': 
                case 'f': {
                    return new FloatLiteral(this.getImage());
                }
                case 'D': 
                case 'd': {
                    return new DoubleLiteral(this.getImage());
                }
                case 'E': 
                case 'e': {
                    if (seenExponent) {
                        this.skipChars(-1);
                        break block7;
                    }
                    seenExponent = true;
                    if (this.peekChar() == '+') {
                        this.skipChars(1);
                    }
                    if (this.peekChar() != '-') continue block7;
                    this.skipChars(1);
                    continue block7;
                }
                case '.': {
                    if (seenDot || seenExponent) {
                        this.skipChars(-1);
                        break block7;
                    }
                    seenDot = true;
                    continue block7;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block7;
                }
                default: {
                    this.skipChars(-1);
                    break block7;
                }
            }
            break;
        }
        return new DoubleLiteral(this.getImage());
    }

    private Token getStringLiteral() {
        this.skipChars(1);
        StringBuffer contents = new StringBuffer();
        while (true) {
            char ch = this.eatChar();
            switch (ch) {
                case '\"': {
                    return new StringLiteral(contents.toString());
                }
                case '\\': {
                    ch = this.processCharacterEscape();
                    break;
                }
                case '\n': {
                    throw this.tokenError("newline not allowed in string literal");
                }
            }
            contents.append(ch);
        }
    }

    private void skipStringLiteral() {
        while (true) {
            char ch = this.eatChar();
            switch (ch) {
                case '\"': {
                    return;
                }
                case '\\': {
                    ch = this.processCharacterEscape();
                    break;
                }
                case '\n': {
                    throw this.tokenError("newline not allowed in string literal");
                }
            }
        }
    }

    private Token getCharacterLiteral() {
        this.skipChars(1);
        return new CharacterLiteral(this.getCharacterLiteralInternal());
    }

    private void skipCharacterLiteral() {
        this.getCharacterLiteralInternal();
    }

    private char getCharacterLiteralInternal() {
        char ch = this.eatChar();
        switch (ch) {
            case '\'': {
                throw this.tokenError("empty character literal");
            }
            case '\\': {
                ch = this.processCharacterEscape();
                break;
            }
            case '\n': {
                throw this.tokenError("newline not allowed in character literal");
            }
        }
        if (this.eatChar() != '\'') {
            throw this.tokenError("character literal too long");
        }
        return ch;
    }

    private char processCharacterEscape() {
        char ch = this.eatChar();
        switch (ch) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
        }
        if (ch < '0' || ch > '7') {
            throw this.tokenError("octal escape must use values 0-7");
        }
        char ch1 = this.peekChar();
        if (ch1 >= '0' && ch1 <= '7') {
            this.eatChar();
            char ch2 = this.peekChar();
            if (ch < '4' && ch2 >= '0' && ch2 <= '7') {
                this.eatChar();
                return (char)(ch2 - 48 + (ch1 - 48) * 8 + (ch - 48) * 64);
            }
            return (char)(ch1 - 48 + (ch - 48) * 8);
        }
        return (char)(ch - 48);
    }

    private Token getToken() {
        State state = beginState;
        while (!state.isEndState()) {
            if ((state = state.forCharacter(this.eatChar())) != null) continue;
            return this.getIdentifier();
        }
        this.skipChars(-1);
        if (state.isKeyword() && Character.isJavaIdentifierPart(this.peekChar())) {
            while (Character.isJavaIdentifierPart(this.eatChar())) {
            }
            this.skipChars(-1);
            return new Token(70, this.getImage(), true);
        }
        return ((EndState)state).getToken();
    }

    private Token getIdentifier() {
        this.index = this.startIndex;
        if (!Character.isJavaIdentifierStart(this.eatChar())) {
            throw this.tokenError("identifier expected");
        }
        while (Character.isJavaIdentifierPart(this.eatChar())) {
        }
        this.skipChars(-1);
        return new Token(70, this.getImage(), true);
    }

    public static int addOperator(String image) {
        return JavaTokenizer.addOperator(-1, image);
    }

    public static int addOperator(int kindV, String image) {
        Integer kind = (Integer)knownOperators.get(image);
        if (kind != null) {
            return kind;
        }
        if (kindV == -1) {
            kindV = knownOperators.size() + 100;
        }
        kind = new Integer(kindV);
        EndState endState = new EndState(kind, image, JavaTokenizer.isIdentifier(image));
        knownOperators.put(image, kind);
        beginState.addEndState(image, 0, endState);
        return kind;
    }

    public static final boolean isIdentifier(String image) {
        int n = image.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(image.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < n) {
            if (!Character.isJavaIdentifierPart(image.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    char[] readCharArray(File file) throws IOException {
        char[] cArray;
        FileInputStream fstream = new FileInputStream(file);
        Reader reader = this.getOptions().encoding == null ? new InputStreamReader(new BufferedInputStream(fstream)) : new InputStreamReader((InputStream)new BufferedInputStream(fstream), this.getOptions().encoding);
        reader = new BufferedReader(reader);
        try {
            int length;
            char[] buf = new char[4096];
            CharArrayWriter caw = new CharArrayWriter();
            while ((length = reader.read(buf, 0, 4096)) != -1) {
                void var4_6;
                caw.write(buf, 0, (int)var4_6);
            }
            caw.write(10);
            cArray = caw.toCharArray();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fstream.close();
            throw throwable;
        }
        fstream.close();
        return cArray;
    }

    private char[] processUnicodeEscapes(char[] text) {
        CharArrayWriter writer = null;
        int N = text.length;
        int i = 0;
        while (i < N) {
            block11: {
                char ch = text[i];
                if (ch == '\\') {
                    boolean oddSlashes = true;
                    int startIndex = i;
                    while (++i < N) {
                        ch = text[i];
                        if (ch == '\\') {
                            oddSlashes = !oddSlashes;
                            continue;
                        }
                        if (ch != 'u' || !oddSlashes) break;
                        if (writer == null) {
                            writer = new CharArrayWriter();
                            writer.write(text, 0, i - 1);
                        }
                        while (text[++i] == 'u') {
                        }
                        if (--i + 4 > N) {
                            throw new ParseException(i, null, "invalid unicode escape");
                        }
                        int v = Character.digit(text[++i], 16);
                        v = v * 16 + Character.digit(text[++i], 16);
                        v = v * 16 + Character.digit(text[++i], 16);
                        v = v * 16 + Character.digit(text[++i], 16);
                        ch = (char)v;
                        writer.write(ch);
                        break block11;
                    }
                    if (writer != null) {
                        writer.write(text, startIndex, i + 1 - startIndex);
                    }
                } else if (writer != null) {
                    writer.write(ch);
                }
            }
            ++i;
        }
        if (writer != null) {
            return writer.toCharArray();
        }
        return text;
    }

    public void setSourceInfo(SourceInfo si) throws IOException {
        char[] text = this.readCharArray(si.getFile());
        text = this.processUnicodeEscapes(text);
        si.setText(text);
        this.sourceInfo = si;
        this.text = text;
        this.index = 0;
        this.startIndex = 0;
        this.nChars = text.length;
    }

    public void setOffset(int offset) {
        this.startIndex = this.index = offset;
    }

    public JavaTokenizer(JavaCompiler compiler) {
        super(compiler);
        JavaTokenizer.addOperator(21, "(");
        JavaTokenizer.addOperator(22, ")");
        JavaTokenizer.addOperator(23, "{");
        JavaTokenizer.addOperator(24, "}");
        JavaTokenizer.addOperator(25, "[");
        JavaTokenizer.addOperator(26, "]");
        JavaTokenizer.addOperator(27, ";");
        JavaTokenizer.addOperator(28, ",");
        JavaTokenizer.addOperator(29, ".");
        JavaTokenizer.addOperator(30, "=");
        JavaTokenizer.addOperator(31, ">");
        JavaTokenizer.addOperator(32, "<");
        JavaTokenizer.addOperator(33, "!");
        JavaTokenizer.addOperator(34, "~");
        JavaTokenizer.addOperator(35, "?");
        JavaTokenizer.addOperator(36, ":");
        JavaTokenizer.addOperator(37, "==");
        JavaTokenizer.addOperator(38, "<=");
        JavaTokenizer.addOperator(39, ">=");
        JavaTokenizer.addOperator(40, "!=");
        JavaTokenizer.addOperator(41, "||");
        JavaTokenizer.addOperator(42, "&&");
        JavaTokenizer.addOperator(43, "++");
        JavaTokenizer.addOperator(44, "--");
        JavaTokenizer.addOperator(45, "+");
        JavaTokenizer.addOperator(46, "-");
        JavaTokenizer.addOperator(47, "*");
        JavaTokenizer.addOperator(48, "/");
        JavaTokenizer.addOperator(49, "&");
        JavaTokenizer.addOperator(50, "|");
        JavaTokenizer.addOperator(51, "^");
        JavaTokenizer.addOperator(52, "%");
        JavaTokenizer.addOperator(53, "<<");
        JavaTokenizer.addOperator(54, ">>");
        JavaTokenizer.addOperator(55, ">>>");
        JavaTokenizer.addOperator(56, "+=");
        JavaTokenizer.addOperator(57, "-=");
        JavaTokenizer.addOperator(58, "*=");
        JavaTokenizer.addOperator(59, "/=");
        JavaTokenizer.addOperator(60, "&=");
        JavaTokenizer.addOperator(61, "|=");
        JavaTokenizer.addOperator(62, "^=");
        JavaTokenizer.addOperator(63, "%=");
        JavaTokenizer.addOperator(64, "<<=");
        JavaTokenizer.addOperator(65, ">>=");
        JavaTokenizer.addOperator(66, ">>>=");
        JavaTokenizer.addOperator(67, "instanceof");
        JavaTokenizer.addOperator(68, "new");
        JavaTokenizer.addOperator(73, "public");
        JavaTokenizer.addOperator(74, "private");
        JavaTokenizer.addOperator(75, "protected");
        JavaTokenizer.addOperator(76, "static");
        JavaTokenizer.addOperator(77, "final");
        JavaTokenizer.addOperator(78, "synchronized");
        JavaTokenizer.addOperator(79, "volatile");
        JavaTokenizer.addOperator(80, "transient");
        JavaTokenizer.addOperator(81, "native");
        JavaTokenizer.addOperator(82, "abstract");
        JavaTokenizer.addOperator(83, "strictfp");
        JavaTokenizer.addOperator(84, "const");
        JavaTokenizer.addOperator(85, "class");
        JavaTokenizer.addOperator(86, "interface");
        JavaTokenizer.addOperator(87, "throws");
        JavaTokenizer.addOperator(88, "try");
        JavaTokenizer.addOperator(89, "catch");
        JavaTokenizer.addOperator(90, "finally");
        JavaTokenizer.addOperator(91, "if");
        JavaTokenizer.addOperator(92, "while");
        JavaTokenizer.addOperator(93, "do");
        JavaTokenizer.addOperator(94, "for");
        JavaTokenizer.addOperator(95, "switch");
        JavaTokenizer.addOperator(96, "case");
        JavaTokenizer.addOperator(0, "default");
        JavaTokenizer.addOperator(98, "break");
        JavaTokenizer.addOperator(99, "continue");
        JavaTokenizer.addOperator(100, "return");
        JavaTokenizer.addOperator(101, "throw");
        JavaTokenizer.addOperator(102, "goto");
        this.sourceInfo = null;
    }

    private static class ArrayState
    extends State {
        private static final int MAX_CHAR = 128;
        private State[] states = new State[128];
        State defaultState = null;

        private ArrayState() {
        }

        public State addEndState(String image, int index, EndState endState) {
            if (index >= image.length()) {
                this.defaultState = endState;
                return this;
            }
            char ch = image.charAt(index);
            State newState = this.states[ch];
            if (newState == null) {
                newState = image.length() >= index ? new ArrayState() : endState;
            }
            this.states[ch] = newState.addEndState(image, index + 1, endState);
            return this;
        }

        public State forCharacter(char ch) {
            State state;
            if (ch >= '\u0000' && ch < '\u0080' && (state = this.states[ch]) != null) {
                return state;
            }
            return this.defaultState;
        }
    }

    private static class EndState
    extends State {
        private int kind;
        private String image;
        private boolean isIdentifier;

        public EndState(int kind, String image, boolean isIdentifier) {
            this.kind = kind;
            this.image = image;
            this.isIdentifier = isIdentifier;
        }

        public Token getToken() {
            return new Token(this.kind, this.image, this.isIdentifier);
        }

        public State forCharacter(char ch) {
            return null;
        }

        public boolean isEndState() {
            return true;
        }

        public boolean isKeyword() {
            return this.isIdentifier;
        }

        public State addEndState(String image, int index, EndState endState) {
            if (image.length() >= index) {
                return endState;
            }
            ArrayState newState = new ArrayState();
            newState.defaultState = this;
            return newState.addEndState(image, index, endState);
        }
    }

    private static abstract class State {
        private State() {
        }

        public State forCharacter(char ch) {
            return null;
        }

        public boolean isEndState() {
            return false;
        }

        public boolean isKeyword() {
            return false;
        }

        public Object getData() {
            return null;
        }

        public abstract State addEndState(String var1, int var2, EndState var3);
    }
}

