/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.TopJpPlanner;

public class AdvicePlannerPass
extends WalkerPass {
    List planners;

    public AdvicePlannerPass(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "planning advice";
    }

    public void transformWorld() {
        this.initializeJoinPointPlanners();
        super.transformWorld();
    }

    void initializeJoinPointPlanners() {
        this.planners = this.getWorld().getJpPlanners();
    }

    protected void postProcess(ASTObject object) {
        if (object instanceof TypeDec) {
            this.plan((TypeDec)object);
        }
    }

    public void plan(TypeDec typeDec) {
        this.makePlans(typeDec.joinPoints0);
        this.makePlans(typeDec.joinPoints1);
        this.makePlans(typeDec.joinPoints2);
    }

    void planJoinPoint(JoinPoint jp) {
        Iterator i = this.planners.iterator();
        while (i.hasNext()) {
            TopJpPlanner jpPlanner = (TopJpPlanner)i.next();
            jpPlanner.plan(jp);
        }
    }

    void makePlans(List jps) {
        Iterator i = jps.iterator();
        while (i.hasNext()) {
            JoinPoint joinPoint = (JoinPoint)i.next();
            this.planJoinPoint(joinPoint);
        }
    }
}

