/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlannerMaker;

public class BuildAdvicePlannersPass
extends AbstractCompilerPass {
    public BuildAdvicePlannersPass(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDisplayName() {
        return "building advice planners";
    }

    public void transform(TypeDec td) {
        if (td instanceof AspectDec) {
            this.initializeAspect((AspectDec)td);
        }
        int N = td.getBody().size();
        int i = 0;
        while (i < N) {
            Dec dec = td.getBody().get(i);
            if (dec instanceof TypeDec) {
                this.transform((TypeDec)dec);
            }
            ++i;
        }
    }

    public void initializeAspect(AspectDec aspectDec) {
        JpPlanner planner;
        if (aspectDec.isAbstract()) {
            return;
        }
        this.getCompiler().enterNode(aspectDec);
        PerClause perClause = aspectDec.getPerClause();
        if (perClause != null && (planner = perClause.makeInitializerPlanner(new PlanData(aspectDec, null))) != null) {
            this.getWorld().addJpPlanner(planner);
        }
        List jpPlannerMakerList = aspectDec.getJpPlannerMakers();
        this.getCompiler().showMessage("  initializing advice in " + aspectDec.toShortString());
        Iterator i = jpPlannerMakerList.iterator();
        while (i.hasNext()) {
            JpPlannerMaker jpPlannerMaker = (JpPlannerMaker)i.next();
            JpPlanner planner2 = jpPlannerMaker.makePlanner(new PlanData(aspectDec, jpPlannerMaker));
            if (planner2 == null) continue;
            this.getWorld().addJpPlanner(planner2);
            this.getCompiler().showMessage("     " + jpPlannerMaker.toShortString());
        }
        Iterator i2 = aspectDec.getExtraPlanners().values().iterator();
        while (i2.hasNext()) {
            this.getWorld().addJpPlanner((JpPlanner)i2.next());
        }
        this.getCompiler().exitNode(aspectDec);
    }
}

