/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.crosscuts.CompilationUnitCorrespondences;
import org.aspectj.tools.ide.SymbolManager;

public class Correspondences
extends CompilerObject {
    private Map corrs = new HashMap();

    public Correspondences(JavaCompiler compiler) {
        super(compiler);
    }

    public CompilationUnitCorrespondences getCompilationUnitCorrespondences(ASTObject node) {
        CompilationUnit cu = node.getCompilationUnit();
        CompilationUnitCorrespondences cuCorrs = (CompilationUnitCorrespondences)this.corrs.get(cu);
        if (cuCorrs == null) {
            cuCorrs = new CompilationUnitCorrespondences(cu);
            this.corrs.put(cu, cuCorrs);
        }
        return cuCorrs;
    }

    public File makeSymFile(File javaFile) {
        return SymbolManager.mapFilenameToSymbolFile(javaFile.getPath());
    }

    public void dump(CompilationUnit cu, CompilationUnitCorrespondences cucorr) {
        this.dump(cu.getSourceFile(), cu, cucorr);
    }

    public void dump(File file, CompilationUnit cu, CompilationUnitCorrespondences cucorr) {
        if (file == null) {
            return;
        }
    }

    public void addPointsTo(ASTObject node1, ASTObject node2) {
        if (node1 == null || node2 == null) {
            return;
        }
        this.getCompilationUnitCorrespondences(node1).addPointsTo(node1, node2);
        this.getCompilationUnitCorrespondences(node2).addPointedToBy(node2, node1);
    }

    public Set getAffects(ASTObject astObject) {
        return this.getCompilationUnitCorrespondences(astObject).getPointsToSet(astObject);
    }

    public Set getAffectedBy(ASTObject astObject) {
        return this.getCompilationUnitCorrespondences(astObject).getPointedToBySet(astObject);
    }
}

