/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AnyCallExpr;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.BangExpr;
import org.aspectj.compiler.base.ast.BasicAssignExpr;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NewArrayExpr;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.SyntheticGetSet;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AroundAdviceDec;
import org.aspectj.compiler.crosscuts.ast.ProceedExpr;
import org.aspectj.compiler.crosscuts.joinpoints.AdviceExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.CalleeSideCallJp;
import org.aspectj.compiler.crosscuts.joinpoints.CodeBodyJp;
import org.aspectj.compiler.crosscuts.joinpoints.CodeDecJp;
import org.aspectj.compiler.crosscuts.joinpoints.ConstructorCallJp;
import org.aspectj.compiler.crosscuts.joinpoints.ConstructorExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.ExceptionHandlerJp;
import org.aspectj.compiler.crosscuts.joinpoints.FieldGetJp;
import org.aspectj.compiler.crosscuts.joinpoints.FieldSetJp;
import org.aspectj.compiler.crosscuts.joinpoints.InitializationJp;
import org.aspectj.compiler.crosscuts.joinpoints.InstanceInitializerExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.MethodCallJp;
import org.aspectj.compiler.crosscuts.joinpoints.MethodExecutionJp;
import org.aspectj.compiler.crosscuts.joinpoints.PreInitializationJp;
import org.aspectj.compiler.crosscuts.joinpoints.StaticInitializerExecutionJp;

public class JoinPointCollector
extends CompilerObject {
    TypeDec typeDec;

    public JoinPointCollector(TypeDec typeDec) {
        super(typeDec.getCompiler());
        this.typeDec = typeDec;
    }

    public void collect() {
        if (this.typeDec.isSynthetic()) {
            return;
        }
        this.getCompiler().showMessage("  collecting join point shadows for " + this.typeDec.toShortString());
        this.collectJoinPoints();
    }

    void collectJoinPoints() {
        if (!(this.typeDec instanceof InterfaceDec)) {
            this.planInitializerExecution(this.typeDec.getSingleInitializerDec(true));
        }
        this.planInitializerExecution(this.typeDec.getSingleInitializerDec(false));
        Decs decs = this.typeDec.getBody();
        int i = 0;
        while (i < decs.size()) {
            Dec dec = decs.get(i);
            if (!(dec instanceof InitializerDec)) {
                if (dec instanceof CodeDec) {
                    this.planJoinPoints((CodeDec)dec);
                } else if (dec instanceof TypeDec) {
                    new JoinPointCollector((TypeDec)dec).collect();
                } else if (dec instanceof FieldDec) {
                    FieldDec field = (FieldDec)dec;
                }
            }
            ++i;
        }
    }

    void planInitializerExecution(InitializerDec dec) {
        CodeDecJp jp = dec.isStatic() ? new StaticInitializerExecutionJp(dec) : new InstanceInitializerExecutionJp(dec);
        this.planBodyJoinPoints(dec, jp);
        this.planJoinPoint(jp);
    }

    JoinPoint makeExecutionJoinPoint(CodeDec codeDec) {
        if (codeDec.isAbstract() || codeDec.getBody() == null) {
            return null;
        }
        if (!codeDec.isLanguageVisible()) {
            return null;
        }
        if (codeDec instanceof MethodDec) {
            return new MethodExecutionJp((MethodDec)codeDec);
        }
        if (codeDec instanceof ConstructorDec) {
            return new ConstructorExecutionJp((ConstructorDec)codeDec);
        }
        if (codeDec instanceof AdviceDec) {
            return new AdviceExecutionJp((AdviceDec)codeDec);
        }
        if (codeDec instanceof InitializerDec) {
            return null;
        }
        throw new RuntimeException("unexpected code: " + codeDec.getClass().getName());
    }

    CalleeSideCallJp planCalleeSideCallPoint(MethodDec methodDec) {
        if (!methodDec.fromSource()) {
            return null;
        }
        if (methodDec.isAbstract()) {
            return null;
        }
        CalleeSideCallJp point = (CalleeSideCallJp)this.getWorld().calleeSideCallPoints.get(methodDec);
        if (point == null) {
            point = new CalleeSideCallJp(methodDec.getDeclaringType().getTypeDec(), methodDec);
            this.getWorld().calleeSideCallPoints.put(methodDec, point);
        }
        return point;
    }

    void planCallPoint(AnyCallExpr callExpr, JoinPoint enclosingJp) {
        if (callExpr instanceof CallExpr) {
            this.planBodyJoinPoint(new MethodCallJp((CallExpr)callExpr, enclosingJp));
        } else {
            this.planBodyJoinPoint(new ConstructorCallJp((NewInstanceExpr)callExpr, enclosingJp));
        }
    }

    void planJoinPoints(CodeDec codeDec) {
        CalleeSideCallJp calleeCallPoint;
        if (!codeDec.isLanguageVisible()) {
            return;
        }
        JoinPoint executionPoint = this.makeExecutionJoinPoint(codeDec);
        if (executionPoint != null) {
            this.planBodyJoinPoints(codeDec.getBody(), executionPoint);
            this.planJoinPoint(executionPoint);
        }
        if (codeDec instanceof ConstructorDec) {
            this.planJoinPoint(new InitializationJp((ConstructorDec)codeDec));
        }
        if (codeDec instanceof MethodDec && (calleeCallPoint = this.planCalleeSideCallPoint((MethodDec)codeDec)) != null) {
            this.typeDec.joinPoints2.add(calleeCallPoint);
        }
    }

    void planBodyJoinPoints(ASTObject node, JoinPoint executionPoint) {
        new BodyPointPlanner(this.getCompiler(), executionPoint).process(node);
    }

    void planJoinPoint(JoinPoint jp) {
        this.typeDec.joinPoints2.add(jp);
    }

    void planBodyJoinPoint(CodeBodyJp jp) {
        AdviceDec ad;
        this.typeDec.joinPoints1.add(jp);
        if (jp.getEnclosingExecutionJoinPoint() instanceof AdviceExecutionJp && (ad = (AdviceDec)jp.getEnclosingExecutionJoinPoint().getTargetDec()) instanceof AroundAdviceDec) {
            ((AroundAdviceDec)ad).joinPoints1.add(jp);
        }
    }

    class BodyPointPlanner
    extends Walker {
        JoinPoint enclosingExecutionJoinPoint;

        public BodyPointPlanner(JavaCompiler compiler, JoinPoint enclosingExecutionJoinPoint) {
            super(compiler);
            this.enclosingExecutionJoinPoint = enclosingExecutionJoinPoint;
        }

        public boolean preProcess(ASTObject node) {
            if (node instanceof ConstructorCallExpr) {
                if (!(this.enclosingExecutionJoinPoint instanceof PreInitializationJp)) {
                    PreInitializationJp preInitPoint = new PreInitializationJp((ConstructorDec)node.getEnclosingCodeDec());
                    JoinPointCollector.this.planJoinPoint(preInitPoint);
                    new BodyPointPlanner(this.getCompiler(), preInitPoint).process(node);
                    return false;
                }
                return true;
            }
            if (node instanceof AnyCallExpr && !(node instanceof NewArrayExpr)) {
                AnyCallExpr callExpr = (AnyCallExpr)node;
                Expr expr = callExpr.getExpr();
                if (callExpr instanceof CallExpr && ((CallExpr)callExpr).getIsSuper()) {
                    return true;
                }
                if (expr instanceof ProceedExpr) {
                    return true;
                }
                JoinPointCollector.this.planCallPoint(callExpr, this.enclosingExecutionJoinPoint);
            } else if (node instanceof CatchClause) {
                CatchClause catchClause = (CatchClause)node;
                JoinPointCollector.this.planBodyJoinPoint(new ExceptionHandlerJp(catchClause, this.enclosingExecutionJoinPoint));
            } else {
                if (node instanceof TypeDec) {
                    new JoinPointCollector((TypeDec)node).collect();
                    return false;
                }
                if (node instanceof FieldAccessExpr) {
                    FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
                    if (fieldAccessExpr.isLhs()) {
                        BangExpr bangExpr = (BangExpr)node.getParent();
                        if (bangExpr instanceof BasicAssignExpr) {
                            this.addSetPoint((AssignExpr)bangExpr);
                        } else {
                            SyntheticGetSet synExpr = new SyntheticGetSet(this.getCompiler(), bangExpr);
                            this.addSetPoint(fieldAccessExpr, synExpr);
                            this.addGetPoint(fieldAccessExpr, synExpr);
                        }
                    } else {
                        this.addGetPoint(fieldAccessExpr);
                    }
                }
            }
            return true;
        }

        void addGetPoint(FieldAccessExpr fieldAccessExpr) {
            FieldGetJp point = new FieldGetJp(new FieldGetJp.FieldGetExprPromise(this, fieldAccessExpr){
                private final /* synthetic */ FieldAccessExpr val$fieldAccessExpr;
                private final /* synthetic */ BodyPointPlanner this$1;
                {
                    this.this$1 = this$1;
                    this.val$fieldAccessExpr = val$fieldAccessExpr;
                }

                public FieldAccessExpr getFieldAccessExpr() {
                    return this.val$fieldAccessExpr;
                }

                public FieldDec getFieldDec() {
                    return this.getFieldAccessExpr().getFieldDec();
                }

                public Expr getSourceExpr() {
                    return this.val$fieldAccessExpr;
                }

                public Type getTargetType() {
                    return this.getFieldAccessExpr().getTargetType();
                }

                public ASTObject getSourceLocation() {
                    return this.val$fieldAccessExpr;
                }
            }, this.enclosingExecutionJoinPoint);
            JoinPointCollector.this.planBodyJoinPoint(point);
        }

        FieldSetJp.FieldSetExprPromise makeFieldSetExprPromise(FieldAccessExpr fieldAccessExpr, SyntheticGetSet synGetSet, boolean useBang) {
            return new FieldSetJp.FieldSetExprPromise(this, synGetSet, fieldAccessExpr, useBang){
                private final /* synthetic */ SyntheticGetSet val$synGetSet;
                private final /* synthetic */ FieldAccessExpr val$fieldAccessExpr;
                private final /* synthetic */ boolean val$useBang;
                private final /* synthetic */ BodyPointPlanner this$1;
                {
                    this.this$1 = this$1;
                    this.val$synGetSet = val$synGetSet;
                    this.val$fieldAccessExpr = val$fieldAccessExpr;
                    this.val$useBang = val$useBang;
                }

                public AssignExpr getAssignExpr() {
                    this.val$synGetSet.makeConcrete();
                    return this.val$synGetSet.makeSetExpr();
                }

                public FieldAccessExpr getFieldAccessExpr() {
                    this.val$synGetSet.makeConcrete();
                    return this.val$synGetSet.makeGetExpr();
                }

                public FieldDec getFieldDec() {
                    return this.val$fieldAccessExpr.getFieldDec();
                }

                public Expr getSourceExpr() {
                    if (this.val$useBang) {
                        return this.val$synGetSet.getBangExpr();
                    }
                    return this.val$fieldAccessExpr;
                }

                public Type getTargetType() {
                    return this.val$fieldAccessExpr.getTargetType();
                }

                public ASTObject getSourceLocation() {
                    return this.val$fieldAccessExpr;
                }
            };
        }

        void addGetPoint(FieldAccessExpr fieldAccessExpr, SyntheticGetSet synGetSet) {
            JoinPointCollector.this.planBodyJoinPoint(new FieldGetJp(this.makeFieldSetExprPromise(fieldAccessExpr, synGetSet, false), this.enclosingExecutionJoinPoint));
        }

        void addSetPoint(FieldAccessExpr fieldAccessExpr, SyntheticGetSet synGetSet) {
            JoinPointCollector.this.planBodyJoinPoint(new FieldSetJp(this.makeFieldSetExprPromise(fieldAccessExpr, synGetSet, true), this.enclosingExecutionJoinPoint));
        }

        void addSetPoint(AssignExpr assignExpr) {
            FieldSetJp point = new FieldSetJp(new FieldSetJp.FieldSetExprPromise(this, assignExpr){
                private final /* synthetic */ AssignExpr val$assignExpr;
                private final /* synthetic */ BodyPointPlanner this$1;
                {
                    this.this$1 = this$1;
                    this.val$assignExpr = val$assignExpr;
                }

                public AssignExpr getAssignExpr() {
                    return this.val$assignExpr;
                }

                public FieldAccessExpr getFieldAccessExpr() {
                    return (FieldAccessExpr)this.val$assignExpr.getLhs();
                }

                public FieldDec getFieldDec() {
                    return this.getFieldAccessExpr().getFieldDec();
                }

                public Expr getSourceExpr() {
                    return this.val$assignExpr;
                }

                public Type getTargetType() {
                    return this.getFieldAccessExpr().getTargetType();
                }

                public ASTObject getSourceLocation() {
                    return this.val$assignExpr;
                }
            }, this.enclosingExecutionJoinPoint);
            JoinPointCollector.this.planBodyJoinPoint(point);
        }
    }
}

