/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;

public class TreeCheckerPass
extends WalkerPass {
    private boolean checkSourceInfo;
    private boolean checkParents;
    private boolean checkResolved;
    private int showRealParentOnExit = -1;

    public TreeCheckerPass(JavaCompiler compiler, boolean checkSourceInfo, boolean checkParents, boolean checkResolved) {
        super(compiler);
        this.checkSourceInfo = checkSourceInfo;
        this.checkParents = checkParents;
        this.checkResolved = checkResolved;
    }

    public String getDisplayName() {
        return "check source:" + this.checkSourceInfo + " parents: " + this.checkParents + " resolved: " + this.checkResolved;
    }

    public ASTObject process(ASTObject object) {
        if (this.checkParents) {
            this.checkParent(object);
        }
        if (this.checkResolved) {
            this.checkResolved(object);
        }
        object.walk(this);
        if (this.showRealParentOnExit > 0) {
            --this.showRealParentOnExit;
        }
        if (this.showRealParentOnExit == 0) {
            object.display(2);
            this.showRealParentOnExit = -1;
        }
        return object;
    }

    void checkSourceInfo(ASTObject object) {
        if (!object.hasSourceLocation()) {
            this.getCompiler().showError(object.getParent(), "no source location");
            object.display(2);
        }
    }

    void checkParent(ASTObject object) {
        if (object.getParent() == null && !(object instanceof CompilationUnit)) {
            object.showError("no parent");
            object.display(2);
            this.showRealParentOnExit = 3;
        }
    }

    void checkResolved(ASTObject object) {
    }
}

